/*
 * Decompiled with CFR 0.152.
 */
package net.hypercubemc.iris_installer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class InstallerMeta {
    private final String metaUrl;
    private String betaSnippet;
    private boolean hasBeta;
    private final List<Version> versions = new ArrayList<Version>();

    public InstallerMeta(String url) {
        this.metaUrl = url;
    }

    public void load() throws IOException, JSONException {
        JSONObject json = InstallerMeta.readJsonFromUrl(this.metaUrl);
        this.betaSnippet = json.getString("betaVersionSnippet");
        this.hasBeta = json.getBoolean("hasBeta");
        json.getJSONArray("versions").toList().forEach(element -> this.versions.add(new Version((HashMap)element)));
    }

    public String getBetaSnippet() {
        return this.betaSnippet;
    }

    public boolean hasBeta() {
        return this.hasBeta;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public static String readAll(Reader reader) throws IOException {
        int codePoint;
        StringBuilder stringBuilder = new StringBuilder();
        while ((codePoint = reader.read()) != -1) {
            stringBuilder.append((char)codePoint);
        }
        return stringBuilder.toString();
    }

    public static JSONObject readJsonFromUrl(String url) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(url).openStream(), StandardCharsets.UTF_8));
        return new JSONObject(InstallerMeta.readAll(bufferedReader));
    }

    public static class Version {
        boolean outdated;
        boolean snapshot;
        String name;

        public Version(HashMap<String, Object> jsonObject) {
            this.name = (String)jsonObject.get("name");
            this.snapshot = (Boolean)jsonObject.get("snapshot");
            this.outdated = (Boolean)jsonObject.get("outdated");
        }

        public String toString() {
            return this.name;
        }
    }
}

