/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.supermartijn642.core.render.RenderStateConfiguration;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class RenderConfiguration
extends RenderType {
    public static RenderConfiguration create(String modid, String name, VertexFormat format, PrimitiveType primitive, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderStateConfiguration renderStateConfiguration) {
        return new RenderConfiguration(modid + ":" + name, format, primitive.getUnderlying(), bufferSize, affectsCrumbling, sortOnUpload, renderStateConfiguration::setup, renderStateConfiguration::clear);
    }

    public static RenderConfiguration wrap(RenderType renderType) {
        if (renderType instanceof RenderConfiguration) {
            return (RenderConfiguration)renderType;
        }
        return new RenderConfiguration(renderType.toString(), renderType.m_110508_(), renderType.m_173186_(), renderType.m_110507_(), renderType.m_110405_(), renderType.f_110393_, () -> ((RenderType)renderType).m_110185_(), () -> ((RenderType)renderType).m_110188_());
    }

    private RenderConfiguration(String name, VertexFormat format, VertexFormat.Mode primitive, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setup, Runnable clear) {
        super(name, format, primitive, bufferSize, affectsCrumbling, sortOnUpload, setup, clear);
    }

    public VertexConsumer begin(MultiBufferSource bufferSource) {
        return bufferSource.m_6299_((RenderType)this);
    }

    public void end(MultiBufferSource.BufferSource bufferSource) {
        bufferSource.m_109912_((RenderType)this);
    }

    public static enum PrimitiveType {
        LINES(1, 2, 2, false, VertexFormat.Mode.DEBUG_LINES),
        LINE_STRIP(3, 2, 1, true, VertexFormat.Mode.DEBUG_LINE_STRIP),
        TRIANGLE_LINES(4, 2, 2, false, VertexFormat.Mode.LINES),
        TRIANGLE_LINE_STRIP(5, 2, 1, true, VertexFormat.Mode.LINE_STRIP),
        TRIANGLES(4, 3, 3, false, VertexFormat.Mode.TRIANGLES),
        TRIANGLE_STRIP(5, 3, 1, true, VertexFormat.Mode.DEBUG_LINES),
        TRIANGLE_FAN(6, 3, 1, true, VertexFormat.Mode.TRIANGLE_FAN),
        QUADS(7, 4, 4, false, VertexFormat.Mode.QUADS);

        private final int glMode;
        private final int vertexCount;
        private final int vertexOffset;
        private final boolean isConnected;
        private final VertexFormat.Mode underlying;

        private PrimitiveType(int glMode, int vertexCount, int vertexOffset, boolean isConnected, VertexFormat.Mode underlying) {
            this.glMode = glMode;
            this.vertexCount = vertexCount;
            this.vertexOffset = vertexOffset;
            this.isConnected = isConnected;
            this.underlying = underlying;
        }

        public int getGlMode() {
            return this.glMode;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public int getVertexOffset() {
            return this.vertexOffset;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        @Deprecated
        public VertexFormat.Mode getUnderlying() {
            return this.underlying;
        }
    }
}

