/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.util;

import com.misterpemodder.shulkerboxtooltip.api.config.ItemStackMergingStrategy;
import com.misterpemodder.shulkerboxtooltip.impl.util.ItemKey;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class MergedItemStack
implements Comparable<MergedItemStack> {
    private ItemStack merged = ItemStack.f_41583_;
    private final NonNullList<ItemStack> subItems;
    private int firstSlot;

    public MergedItemStack(int slotCount) {
        this.subItems = NonNullList.m_122780_((int)slotCount, (Object)ItemStack.f_41583_);
        this.firstSlot = Integer.MAX_VALUE;
    }

    public ItemStack get() {
        return this.merged;
    }

    public void add(ItemStack stack, int slot, ItemStackMergingStrategy mergingStrategy) {
        if (slot < 0 || slot >= this.subItems.size()) {
            return;
        }
        this.subItems.set(slot, (Object)stack.m_41777_());
        if (slot < this.firstSlot) {
            this.firstSlot = slot;
        }
        if (this.merged.m_41619_()) {
            this.merged = stack.m_41777_();
            if (mergingStrategy == ItemStackMergingStrategy.IGNORE) {
                this.merged.m_41751_(null);
            }
        } else {
            this.merged.m_41769_(stack.m_41613_());
        }
    }

    public ItemStack getSubStack(int slot) {
        if (slot < 0 || slot >= this.subItems.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.subItems.get(slot);
    }

    public int size() {
        return this.subItems.size();
    }

    @Override
    public int compareTo(MergedItemStack other) {
        int ret = this.merged.m_41613_() - other.merged.m_41613_();
        if (ret != 0) {
            return ret;
        }
        return other.firstSlot - this.firstSlot;
    }

    public static List<MergedItemStack> mergeInventory(List<ItemStack> inventory, int maxSize, ItemStackMergingStrategy mergingStrategy) {
        ArrayList<MergedItemStack> items = new ArrayList<MergedItemStack>();
        if (!inventory.isEmpty()) {
            HashMap<ItemKey, MergedItemStack> mergedStacks = new HashMap<ItemKey, MergedItemStack>();
            int len = inventory.size();
            for (int i = 0; i < len; ++i) {
                ItemStack s = inventory.get(i);
                if (s.m_41619_()) continue;
                ItemKey k = new ItemKey(s, mergingStrategy != ItemStackMergingStrategy.SEPARATE);
                MergedItemStack mergedStack = (MergedItemStack)mergedStacks.get(k);
                if (mergedStack == null) {
                    mergedStack = new MergedItemStack(maxSize);
                    mergedStacks.put(k, mergedStack);
                }
                mergedStack.add(s, i, mergingStrategy);
            }
            items.addAll(mergedStacks.values());
            items.sort(Comparator.reverseOrder());
        }
        return items;
    }
}

