/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.forge;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.RegistrationChangeType;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;

final class ChannelListener {
    private static final Supplier<String> DUMMY_VERSION = () -> "1";
    private static final Predicate<String> MATCH_ALL = v -> true;
    private static final Map<ResourceLocation, ChannelListener> INSTANCES = new HashMap<ResourceLocation, ChannelListener>();
    public ServerNetworking.PacketReceiver c2sPacketReceiver;
    public ServerNetworking.RegistrationChangeListener c2sRegChangeListener;
    @OnlyIn(value=Dist.CLIENT)
    public ClientNetworking.PacketReceiver s2cPacketReceiver;
    @OnlyIn(value=Dist.CLIENT)
    public ClientNetworking.RegistrationChangeListener s2cRegChangeListener;

    private ChannelListener(EventNetworkChannel eventChannel) {
        eventChannel.addListener(this::onServerEvent);
        if (ShulkerBoxTooltip.isClient()) {
            eventChannel.addListener(this::onClientEvent);
        }
    }

    public static ChannelListener get(ResourceLocation channelId) {
        return INSTANCES.computeIfAbsent(channelId, id -> new ChannelListener(NetworkRegistry.newEventChannel((ResourceLocation)id, DUMMY_VERSION, MATCH_ALL, MATCH_ALL)));
    }

    private static ServerPlayer sender(NetworkEvent event) {
        return ((NetworkEvent.Context)event.getSource().get()).getSender();
    }

    private static RegistrationChangeType registrationChangeType(NetworkEvent.ChannelRegistrationChangeEvent event) {
        return switch (event.getRegistrationChangeType()) {
            default -> throw new IncompatibleClassChangeError();
            case NetworkEvent.RegistrationChangeType.REGISTER -> RegistrationChangeType.REGISTER;
            case NetworkEvent.RegistrationChangeType.UNREGISTER -> RegistrationChangeType.UNREGISTER;
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onServerEvent(NetworkEvent event) {
        if (event instanceof NetworkEvent.ClientCustomPayloadEvent) {
            NetworkEvent.ClientCustomPayloadEvent customPayloadEvent = (NetworkEvent.ClientCustomPayloadEvent)event;
            if (this.c2sPacketReceiver != null) {
                this.c2sPacketReceiver.handle(ChannelListener.sender((NetworkEvent)customPayloadEvent), customPayloadEvent.getPayload());
                ((NetworkEvent.Context)customPayloadEvent.getSource().get()).setPacketHandled(true);
                return;
            }
        }
        if (!(event instanceof NetworkEvent.ChannelRegistrationChangeEvent)) return;
        NetworkEvent.ChannelRegistrationChangeEvent regEvent = (NetworkEvent.ChannelRegistrationChangeEvent)event;
        if (this.c2sRegChangeListener == null) return;
        this.c2sRegChangeListener.onRegistrationChange(ChannelListener.sender((NetworkEvent)regEvent), ChannelListener.registrationChangeType(regEvent));
    }

    /*
     * Enabled aggressive block sorting
     */
    @OnlyIn(value=Dist.CLIENT)
    private void onClientEvent(NetworkEvent event) {
        if (event instanceof NetworkEvent.ServerCustomPayloadEvent) {
            NetworkEvent.ServerCustomPayloadEvent customPayloadEvent = (NetworkEvent.ServerCustomPayloadEvent)event;
            if (this.s2cPacketReceiver != null) {
                this.s2cPacketReceiver.handle(customPayloadEvent.getPayload());
                ((NetworkEvent.Context)customPayloadEvent.getSource().get()).setPacketHandled(true);
                return;
            }
        }
        if (!(event instanceof NetworkEvent.ChannelRegistrationChangeEvent)) return;
        NetworkEvent.ChannelRegistrationChangeEvent regEvent = (NetworkEvent.ChannelRegistrationChangeEvent)event;
        if (this.s2cRegChangeListener == null) return;
        this.s2cRegChangeListener.onRegistrationChange(ChannelListener.registrationChangeType(regEvent));
    }
}

