/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

public interface ShulkerBoxTooltipApi {
    @Nullable
    public static PreviewProvider getPreviewProviderForStack(ItemStack stack) {
        return PreviewProviderRegistry.getInstance().get(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isPreviewAvailable(PreviewContext context) {
        return ShulkerBoxTooltipClient.isPreviewAvailable(context);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static PreviewType getCurrentPreviewType(boolean hasFullPreviewMode) {
        return ShulkerBoxTooltipClient.getCurrentPreviewType(hasFullPreviewMode);
    }

    @Deprecated(forRemoval=true, since="4.0.3")
    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static boolean isPreviewKeyPressed() {
        return ShulkerBoxTooltipClient.isPreviewKeyPressed();
    }

    @Deprecated(forRemoval=true, since="4.0.3")
    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static boolean isFullPreviewKeyPressed() {
        return ShulkerBoxTooltipClient.isFullPreviewKeyPressed();
    }

    public static boolean hasModAvailable(ServerPlayer player) {
        return ServerNetworking.hasModAvailable(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void registerColors(ColorRegistry registry) {
    }

    public void registerProviders(PreviewProviderRegistry var1);
}

