/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyFilterSlot;
import com.refinedmods.refinedstorage.network.SetFilterSlotMessage;
import com.refinedmods.refinedstorage.network.SetFluidFilterSlotMessage;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GhostIngredientHandler
implements IGhostIngredientHandler<BaseScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(BaseScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (final Slot slot : gui.m_6262_().f_38839_) {
            if (!slot.m_6659_()) continue;
            final Rect2i bounds = new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 17, 17);
            if (ingredient.getIngredient() instanceof ItemStack && (slot instanceof LegacyFilterSlot || slot instanceof FilterSlot)) {
                targets.add(new IGhostIngredientHandler.Target<I>(){

                    public Rect2i getArea() {
                        return bounds;
                    }

                    public void accept(I ingredient) {
                        slot.m_5852_((ItemStack)ingredient);
                        RS.NETWORK_HANDLER.sendToServer(new SetFilterSlotMessage(slot.f_40219_, (ItemStack)ingredient));
                    }
                });
                continue;
            }
            if (!(ingredient instanceof FluidStack) || !(slot instanceof FluidFilterSlot)) continue;
            targets.add(new IGhostIngredientHandler.Target<I>(){

                public Rect2i getArea() {
                    return bounds;
                }

                public void accept(I ingredient) {
                    RS.NETWORK_HANDLER.sendToServer(new SetFluidFilterSlotMessage(slot.f_40219_, StackUtils.copy((FluidStack)ingredient, 1000)));
                }
            });
        }
        return targets;
    }

    public void onComplete() {
    }
}

