/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.datageneration;

import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.datageneration.BlockModelGenerator;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockModels {
    private final BlockModelGenerator generator;

    public BlockModels(BlockModelGenerator blockModelGenerator) {
        this.generator = blockModelGenerator;
    }

    public void simpleBlockStateModel(Block block, Function<BlockState, ModelFile> model) {
        this.generator.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)model.apply((BlockState)state)).build());
    }

    public void anyDirectionalRSBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.generator.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockDirection.ANY.getProperty());
            int xRotation = 0;
            if (dir == Direction.DOWN) {
                xRotation = 180;
            }
            if (dir.m_122434_().m_122479_()) {
                xRotation = 90;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(xRotation).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + angleOffset) % 360).build();
        });
    }

    public void wirelessTransmitterBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.generator.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockDirection.ANY.getProperty());
            int xRotation = dir.m_122434_() == Direction.Axis.Y ? (dir == Direction.UP ? 180 : 0) : (dir.m_122434_().m_122479_() ? 90 : 0);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(xRotation).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + angleOffset) % 360).build();
        });
    }

    public void horizontalRSBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.generator.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockDirection.HORIZONTAL.getProperty())).m_122435_() + angleOffset) % 360).build());
    }

    public void customLoaderRSBlock(Block block, ResourceLocation path, ModelFile connectedModel, ModelFile disconnectedModel) {
        BlockModelBuilder model = (BlockModelBuilder)((CustomLoaderBuilderBasic)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().getBuilder(path.toString())).renderType("cutout")).customLoader((builder, filehelper) -> new CustomLoaderBuilderBasic(new ResourceLocation("refinedstorage", "disk_manipulator"), (BlockModelBuilder)builder, (ExistingFileHelper)filehelper))).end();
        this.generator.getVariantBuilder(block).setModels(this.generator.getVariantBuilder(block).partialState(), new ConfiguredModel[]{ConfiguredModel.builder().modelFile((ModelFile)model).buildLast()});
    }

    public BlockModelBuilder createDetectorModel(String name, ResourceLocation torch) {
        return (BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "detector"))).texture("torch", torch);
    }

    public BlockModelBuilder createDetectorNonEmissiveModel(String name, ResourceLocation torch) {
        return (BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "detector_nonemissive"))).texture("torch", torch);
    }

    public BlockModelBuilder createWirelessTransmitterModel(String name, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "wireless_transmitter"))).texture("cutout", cutout);
    }

    public BlockModelBuilder createWirelessTransmitterNonEmissiveModel(String name, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "wireless_transmitter_nonemissive"))).texture("cutout", cutout);
    }

    public BlockModelBuilder createCubeCutoutModel(String name, ResourceLocation down, ResourceLocation downCutout, ResourceLocation up, ResourceLocation upCutout, ResourceLocation east, ResourceLocation eastCutout, ResourceLocation west, ResourceLocation westCutout, ResourceLocation north, ResourceLocation northCutout, ResourceLocation south, ResourceLocation southCutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "cube_cutout"))).texture("particle", north)).texture("east", east)).texture("south", south)).texture("west", west)).texture("up", up)).texture("down", down)).texture("north", north)).texture("cutout_down", downCutout)).texture("cutout_east", eastCutout)).texture("cutout_west", westCutout)).texture("cutout_south", southCutout)).texture("cutout_north", northCutout)).texture("cutout_up", upCutout);
    }

    public BlockModelBuilder createCubeCutoutNonEmissiveModel(String name, ResourceLocation down, ResourceLocation downCutout, ResourceLocation up, ResourceLocation upCutout, ResourceLocation east, ResourceLocation eastCutout, ResourceLocation west, ResourceLocation westCutout, ResourceLocation north, ResourceLocation northCutout, ResourceLocation south, ResourceLocation southCutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "cube_cutout_nonemissive"))).texture("particle", north)).texture("east", east)).texture("south", south)).texture("west", west)).texture("up", up)).texture("down", down)).texture("north", north)).texture("cutout_down", downCutout)).texture("cutout_east", eastCutout)).texture("cutout_west", westCutout)).texture("cutout_south", southCutout)).texture("cutout_north", northCutout)).texture("cutout_up", upCutout);
    }

    public BlockModelBuilder createControllerNearlyCutoutModel(String name, ResourceLocation particle, ResourceLocation all, ResourceLocation grayCutout, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "block/controller_nearly"))).texture("particle", particle)).texture("all", all)).texture("cutout_gray", grayCutout)).texture("cutout", cutout);
    }

    public BlockModelBuilder createCubeAllCutoutModel(String name, ResourceLocation particle, ResourceLocation all, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "cube_all_cutout"))).texture("particle", particle)).texture("all", all)).texture("cutout", cutout);
    }

    public BlockModelBuilder createCubeAllCutoutNonEmissiveModel(String name, ResourceLocation particle, ResourceLocation all, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "cube_all_cutout_nonemissive"))).texture("particle", particle)).texture("all", all)).texture("cutout", cutout);
    }

    public BlockModelBuilder createCubeNorthCutoutModel(String name, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west, ResourceLocation particle, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "cube_north_cutout"))).texture("particle", particle)).texture("east", east)).texture("south", south)).texture("west", west)).texture("up", up)).texture("down", down)).texture("north", north)).texture("cutout", cutout);
    }

    public BlockModelBuilder createCubeNorthCutoutNonEmissiveModel(String name, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west, ResourceLocation particle, ResourceLocation cutout) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.generator.models().withExistingParent(name, new ResourceLocation("refinedstorage", "cube_north_cutout_nonemissive"))).texture("particle", particle)).texture("east", east)).texture("south", south)).texture("west", west)).texture("up", up)).texture("down", down)).texture("north", north)).texture("cutout", cutout);
    }

    class CustomLoaderBuilderBasic
    extends CustomLoaderBuilder<BlockModelBuilder> {
        protected CustomLoaderBuilderBasic(ResourceLocation loaderId, BlockModelBuilder parent, ExistingFileHelper existingFileHelper) {
            super(loaderId, (ModelBuilder)parent, existingFileHelper);
        }
    }
}

