/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.util.DirectionUtils;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.properties.DirectionProperty;

public enum BlockDirection {
    NONE(new Direction[0]),
    ANY(Direction.values()),
    ANY_FACE_PLAYER(Direction.values()),
    HORIZONTAL(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);

    private final DirectionProperty property;

    private BlockDirection(Direction ... allowed) {
        this.property = DirectionProperty.m_61543_((String)"direction", Arrays.asList(allowed));
    }

    public DirectionProperty getProperty() {
        return this.property;
    }

    public Direction getFrom(Direction facing, BlockPos pos, LivingEntity entity) {
        switch (this) {
            case ANY: {
                return facing.m_122424_();
            }
            case ANY_FACE_PLAYER: {
                return DirectionUtils.getFacingFromEntity(pos, entity);
            }
            case HORIZONTAL: {
                return entity.m_6350_().m_122424_();
            }
        }
        throw new IllegalStateException("Unknown direction type");
    }

    public Direction cycle(Direction previous) {
        switch (this) {
            case ANY: 
            case ANY_FACE_PLAYER: {
                return previous.ordinal() + 1 >= Direction.values().length ? Direction.values()[0] : Direction.values()[previous.ordinal() + 1];
            }
            case HORIZONTAL: {
                return previous.m_122428_();
            }
        }
        throw new IllegalStateException("Unknown direction type");
    }
}

