/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.CraftingNode;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.Node;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.ProcessingNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class NodeList {
    private final Map<ICraftingPattern, Node> nodes = new LinkedHashMap<ICraftingPattern, Node>();
    private final List<Node> nodesToRemove = new ArrayList<Node>();

    public void removeMarkedForRemoval() {
        for (Node node : this.nodesToRemove) {
            this.nodes.remove(node.getPattern());
        }
        this.nodesToRemove.clear();
    }

    public Collection<Node> all() {
        return this.nodes.values();
    }

    public void unlockAll(INetwork network) {
        for (Node node : this.nodes.values()) {
            if (!(node instanceof ProcessingNode)) continue;
            network.getCraftingManager().getAllContainers(node.getPattern()).forEach(ICraftingPatternContainer::unlock);
        }
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void remove(Node node) {
        this.nodesToRemove.add(node);
    }

    public Node createOrAddToExistingNode(ICraftingPattern pattern, boolean root, NonNullList<ItemStack> recipe, int qty) {
        Node node = this.nodes.computeIfAbsent(pattern, key -> this.createNode((ICraftingPattern)key, root, recipe));
        node.addQuantity(qty);
        return node;
    }

    private Node createNode(ICraftingPattern pattern, boolean root, NonNullList<ItemStack> recipe) {
        return pattern.isProcessing() ? new ProcessingNode(pattern, root) : new CraftingNode(pattern, root, recipe);
    }

    public void put(ICraftingPattern pattern, Node node) {
        this.nodes.put(pattern, node);
    }
}

