/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.UpwardsBranchingTrunkPlacer;

public class CenteredUpwardsBranchingTrunkPlacer
extends UpwardsBranchingTrunkPlacer {
    public static final Codec<CenteredUpwardsBranchingTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> CenteredUpwardsBranchingTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)IntProvider.f_146533_.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.extraBranchSteps), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.placeBranchPerLogProbability)), (App)IntProvider.f_146532_.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.extraBranchLength))).apply((Applicative)instance, CenteredUpwardsBranchingTrunkPlacer::new));
    private final IntProvider extraBranchSteps;
    private final float placeBranchPerLogProbability;
    private final IntProvider extraBranchLength;

    public CenteredUpwardsBranchingTrunkPlacer(int height, int randA, int randB, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength) {
        super(height, randA, randB, extraBranchSteps, placeBranchPerLogProbability, extraBranchLength, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[0]));
        this.extraBranchSteps = extraBranchSteps;
        this.placeBranchPerLogProbability = placeBranchPerLogProbability;
        this.extraBranchLength = extraBranchLength;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TreeRegistrator.CENTERED_UPWARDS_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        int bleed;
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = bleed = pFreeTreeHeight / 3; i < pFreeTreeHeight - bleed; ++i) {
            int j = pPos.m_123342_() + i;
            if (this.m_226187_(pLevel, pBlockSetter, pRandom, (BlockPos)mutableBlockPos.m_122178_(pPos.m_123341_(), j, pPos.m_123343_()), pConfig) && i < pFreeTreeHeight - 1 && pRandom.m_188501_() < this.placeBranchPerLogProbability) {
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(pRandom);
                int k = this.extraBranchLength.m_214085_(pRandom);
                int l = Math.max(0, k - this.extraBranchLength.m_214085_(pRandom) - 1);
                int i1 = this.extraBranchSteps.m_214085_(pRandom);
                this.m_226212_(pLevel, pBlockSetter, pRandom, pFreeTreeHeight, pConfig, list, mutableBlockPos, j, direction, l, i1);
            }
            if (i != pFreeTreeHeight - 1) continue;
            list.add(new FoliagePlacer.FoliageAttachment((BlockPos)mutableBlockPos.m_122178_(pPos.m_123341_(), j + 1, pPos.m_123343_()), 0, false));
        }
        return list;
    }
}

