/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivelib.util.RecipeUtil;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class TreetapRecipeBuilder
implements RecipeBuilder {
    private final Ingredient log;
    private final ItemStack result;
    private final ItemStack harvestItem;
    private final String fluidColor;
    private final FluidStack displayFluid;
    private final boolean collectBucket;
    private final int processingTime;
    private final int blocksRequired;
    public final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    private TreetapRecipeBuilder(Ingredient log, ItemStack result, ItemStack harvestItem, String fluidColor, FluidStack displayFluid, boolean collectBucket, int processingTime, int blocksRequired) {
        this.log = log;
        this.result = result;
        this.harvestItem = harvestItem;
        this.fluidColor = fluidColor;
        this.displayFluid = displayFluid;
        this.collectBucket = collectBucket;
        this.processingTime = processingTime;
        this.blocksRequired = blocksRequired;
    }

    public static TreetapRecipeBuilder direct(Ingredient log, ItemStack result, ItemStack harvestItem, String fluidColor, FluidStack displayFluid, boolean collectBucket, int processingTime) {
        return new TreetapRecipeBuilder(log, result, harvestItem, fluidColor, displayFluid, collectBucket, processingTime, 5);
    }

    public static TreetapRecipeBuilder direct(Block log, ItemStack result, FluidStack fluid, int processingTime) {
        return TreetapRecipeBuilder.direct(Ingredient.m_43929_((ItemLike[])new ItemLike[]{log}), result, ItemStack.f_41583_, "", fluid, true, processingTime);
    }

    public static TreetapRecipeBuilder direct(Block log, ItemStack result, String fluidColor, int processingTime) {
        return TreetapRecipeBuilder.direct(Ingredient.m_43929_((ItemLike[])new ItemLike[]{log}), result, ItemStack.f_41583_, fluidColor, FluidStack.EMPTY, false, processingTime);
    }

    public static TreetapRecipeBuilder direct(Block log, ItemStack result, ItemStack harvestItem, String fluidColor, int processingTime) {
        return TreetapRecipeBuilder.direct(Ingredient.m_43929_((ItemLike[])new ItemLike[]{log}), result, harvestItem, fluidColor, FluidStack.EMPTY, false, processingTime);
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance criterion) {
        this.advancement.m_138386_(name, criterion);
        return null;
    }

    public RecipeBuilder m_126145_(@Nullable String group) {
        return null;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.log, this.result, this.harvestItem, this.fluidColor, this.displayFluid, this.collectBucket, this.processingTime, this.blocksRequired, this.advancement));
    }

    record Result(ResourceLocation id, Ingredient log, ItemStack result, ItemStack harvestItem, String fluidColor, FluidStack displayFluid, boolean collectBucket, int processingTime, int blocksRequired, Advancement.Builder advancement) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.add("log", this.log.m_43942_());
            json.add("result", (JsonElement)RecipeUtil.itemToJson((ItemStack)this.result));
            json.addProperty("processing_time", (Number)this.processingTime);
            if (!this.harvestItem.m_41619_()) {
                json.add("harvest_item", (JsonElement)RecipeUtil.itemToJson((ItemStack)this.harvestItem));
            }
            if (this.collectBucket) {
                json.addProperty("collect_bucket", Boolean.valueOf(true));
            }
            if (this.blocksRequired > 1) {
                json.addProperty("required_block_count", (Number)this.blocksRequired);
            }
            if (!this.displayFluid.isEmpty()) {
                json.add("display_fluid", (JsonElement)RecipeUtil.fluidToJson((FluidStack)this.displayFluid));
            } else {
                json.addProperty("fluid_color", this.fluidColor);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation("treetap:tap_extract"));
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.id.m_246208_("recipes/" + RecipeCategory.MISC.m_247710_() + "/");
        }
    }
}

