/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivelib.util.RecipeUtil;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class ThermalSawmilRecipeBuilder
implements RecipeBuilder {
    private final Ingredient log;
    private final ItemStack plank;
    private final ItemStack secondary;
    public final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    public ThermalSawmilRecipeBuilder(Ingredient log, ItemStack plank, ItemStack secondary) {
        this.log = log;
        this.plank = plank;
        this.secondary = secondary;
    }

    public static ThermalSawmilRecipeBuilder direct(Ingredient logs, ItemStack plank, ItemStack secondary) {
        return new ThermalSawmilRecipeBuilder(logs, plank, secondary);
    }

    public static ThermalSawmilRecipeBuilder tree(Block log, Block strippedLog, Block wood, Block strippedwood, Block plank) {
        return ThermalSawmilRecipeBuilder.direct(Ingredient.m_43929_((ItemLike[])new ItemLike[]{log, strippedLog, wood, strippedwood}), new ItemStack((ItemLike)plank, 6), new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:sawdust")), 1));
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance criterion) {
        this.advancement.m_138386_(name, criterion);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String p_176495_) {
        return this;
    }

    public Item m_142372_() {
        return this.plank.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.log, this.plank, this.secondary, this.advancement));
    }

    record Result(ResourceLocation id, Ingredient log, ItemStack plank, ItemStack secondary, Advancement.Builder advancement) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.log.m_43942_());
            JsonArray result = new JsonArray();
            result.add((JsonElement)RecipeUtil.itemToJson((ItemStack)this.plank));
            result.add((JsonElement)RecipeUtil.itemChanceToJson((ItemStack)this.secondary, (float)1.25f));
            json.add("result", (JsonElement)result);
            json.addProperty("energy", (Number)1000);
            json.addProperty("experience", (Number)0.15);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation("thermal:sawmill"));
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.id.m_246208_("recipes/" + RecipeCategory.MISC.m_247710_() + "/");
        }
    }
}

