/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.setup.HiveType;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import cy.jdkdigital.productivetrees.util.WoodSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockstateProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    public BlockstateProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashMap blockModels = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.m_6968_();
            BlockStateGenerator blockstategenerator = blockModels.put(block, blockStateGenerator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (resourceLocation, elementSupplier) -> {
            Supplier supplier = itemModels.put(resourceLocation, elementSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        ModelGenerator generator = new ModelGenerator();
        try {
            generator.registerStatesAndModels(blockStateOutput, modelOutput);
        }
        catch (Exception e) {
            ProductiveTrees.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models");
        TreeFinder.trees.forEach((id, treeObject) -> {
            this.addBlockItemModel(TreeUtil.getBlock(id, "_leaves"), "leaves/" + treeObject.getStyle().leafStyle(), itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_planks"), "planks/" + treeObject.getStyle().plankStyle(), itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_log"), "log/" + treeObject.getStyle().woodStyle() + "_log", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_stripped_log"), "log/" + treeObject.getStyle().woodStyle() + "_stripped_log", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_wood"), "log/" + treeObject.getStyle().woodStyle() + "_wood", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_stripped_wood"), "log/" + treeObject.getStyle().woodStyle() + "_stripped_wood", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_slab"), "slab/" + treeObject.getStyle().plankStyle() + "_slab", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_stairs"), "stairs/" + treeObject.getStyle().plankStyle() + "_stairs", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_button"), "button/" + treeObject.getStyle().plankStyle() + "_button_inventory", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_pressure_plate"), "pressure_plate/" + treeObject.getStyle().plankStyle() + "_pressure_plate", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_fence"), "fence/" + treeObject.getStyle().plankStyle() + "_fence_inventory", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_fence_gate"), "fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate", itemModels);
            ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)TreeUtil.getBlock(id, "_door").m_5456_()), new TextureMapping().m_125758_(TextureSlot.f_125863_, new ResourceLocation("productivetrees", "item/door/" + treeObject.getStyle().doorStyle())), modelOutput);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_trapdoor"), "trapdoor/" + treeObject.getStyle().doorStyle() + "_bottom", itemModels);
            this.addBlockItemModel(TreeUtil.getBlock(id, "_bookshelf"), "bookshelf/" + treeObject.getStyle().plankStyle(), itemModels);
            this.generateFlatItem(TreeUtil.getBlock(id, "_sign").m_5456_(), "item/sign/", modelOutput);
            this.generateFlatItem(TreeUtil.getBlock(id, "_hanging_sign").m_5456_(), "item/hanging_sign/", modelOutput);
        });
        this.generateFruitItem((Item)TreeRegistrator.COFFEE_BEAN.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.CAROB.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.ALLSPICE.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.CLOVE.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.CINNAMON.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.NUTMEG.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.STAR_ANISE.get(), modelOutput);
        this.generateFruitItem((Item)TreeRegistrator.PLANET_PEACH.get(), modelOutput);
        this.generateMultiItem((Item)TreeRegistrator.FUSTIC.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.CORK.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.HAEMATOXYLIN.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.DRACAENA_SAP.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.RUBBER.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.CURED_RUBBER.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.MAPLE_SAP_BUCKET.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.MAPLE_SYRUP.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.DATE_PALM_JUICE.get(), "item/", modelOutput);
        this.generateFlatItem((Item)TreeRegistrator.SANDALWOOD_OIL.get(), "item/", modelOutput);
        TreeRegistrator.BERRIES.forEach(cropConfig -> this.generateFruitItem((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivetrees", cropConfig.name())), modelOutput));
        TreeRegistrator.FRUITS.forEach(cropConfig -> this.generateFruitItem((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivetrees", cropConfig.name())), modelOutput));
        TreeRegistrator.NUTS.forEach(cropConfig -> this.generateFruitItem((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivetrees", cropConfig.name())), modelOutput));
        TreeRegistrator.ROASTED_NUTS.forEach(cropConfig -> this.generateFruitItem((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivetrees", cropConfig.name())), modelOutput));
        TreeRegistrator.CRATED_CROPS.forEach(crate -> this.addBlockItemParentModel((Block)ForgeRegistries.BLOCKS.getValue(crate), "crates/", itemModels));
        this.addBlockItemParentModel((Block)TreeRegistrator.SAWMILL.get(), "", itemModels);
        this.addBlockItemParentModel((Block)TreeRegistrator.STRIPPER.get(), "", itemModels);
        this.addBlockItemParentModel((Block)TreeRegistrator.POLLEN_SIFTER.get(), "", itemModels);
        this.addBlockItemParentModel((Block)TreeRegistrator.TIME_TRAVELLER_DISPLAY.get(), "", itemModels);
        this.addBlockItemParentModel((Block)TreeRegistrator.WOOD_WORKER.get(), "", itemModels);
        ArrayList output = new ArrayList();
        blockModels.forEach((block, supplier) -> output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)blockstatePathProvider.m_245731_(ForgeRegistries.BLOCKS.getKey(block)))));
        itemModels.forEach((rLoc, supplier) -> output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)modelPathProvider.m_245731_(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void generateFlatItem(Item item, String prefix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)item), BlockstateProvider.getFlatItemTextureMap(item, prefix), modelOutput);
    }

    private void generateFruitItem(Item item, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        this.generateFlatItem(item, "item/fruit/", modelOutput);
    }

    private void generateMultiItem(Item item, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        this.generateMultiItem(item, "item/fruit/", modelOutput);
    }

    private void generateMultiItem(Item item, String suffix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ResourceLocation tLocation = ForgeRegistries.ITEMS.getKey((Object)item).m_246208_("item/").m_266382_("_two");
        ModelTemplates.f_125658_.m_125612_(tLocation, BlockstateProvider.getFlatItemTextureMap(item, suffix, "_two"), modelOutput);
        ResourceLocation mLocation = ForgeRegistries.ITEMS.getKey((Object)item).m_246208_("item/").m_266382_("_multiple");
        ModelTemplates.f_125658_.m_125612_(mLocation, BlockstateProvider.getFlatItemTextureMap(item, suffix, "_multiple"), modelOutput);
        ModelTemplates.f_125658_.m_266561_(ModelLocationUtils.m_125571_((Item)item), BlockstateProvider.getFlatItemTextureMap(item, suffix), modelOutput, this::createFruitTemplate);
    }

    public JsonObject createFruitTemplate(ResourceLocation resourceLocation, Map<TextureSlot, ResourceLocation> slotResourceLocationMap) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("parent", "minecraft:item/generated");
        if (!slotResourceLocationMap.isEmpty()) {
            JsonObject textureLocations = new JsonObject();
            slotResourceLocationMap.forEach((textureSlot, resourceLocation1) -> textureLocations.addProperty(textureSlot.m_125897_(), resourceLocation1.toString()));
            jsonobject.add("textures", (JsonElement)textureLocations);
        }
        JsonArray overrides = new JsonArray();
        JsonObject twoOverride = new JsonObject();
        JsonObject twoPredicate = new JsonObject();
        twoPredicate.addProperty("count", (Number)2);
        twoOverride.add("predicate", (JsonElement)twoPredicate);
        twoOverride.addProperty("model", resourceLocation.toString() + "_two");
        JsonObject moreOverride = new JsonObject();
        JsonObject morePredicate = new JsonObject();
        morePredicate.addProperty("count", (Number)3);
        moreOverride.add("predicate", (JsonElement)morePredicate);
        moreOverride.addProperty("model", resourceLocation + "_multiple");
        overrides.add((JsonElement)twoOverride);
        overrides.add((JsonElement)moreOverride);
        jsonobject.add("overrides", (JsonElement)overrides);
        return jsonobject;
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix) {
        return BlockstateProvider.getFlatItemTextureMap(item, prefix, "");
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix, String suffix) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)item);
        return new TextureMapping().m_125758_(TextureSlot.f_125863_, resourcelocation.m_246208_(prefix).m_266382_(suffix));
    }

    private void addItemModel(Item item, Supplier<JsonElement> supplier, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ResourceLocation resourcelocation;
        if (item != null && !itemModels.containsKey(resourcelocation = ModelLocationUtils.m_125571_((Item)item))) {
            itemModels.put(resourcelocation, supplier);
        }
    }

    private void addBlockItemModel(Block block, String base, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.f_41373_.get(block);
        if (item != null) {
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(new ResourceLocation("productivetrees", "block/" + base)), itemModels);
        }
    }

    private void addBlockItemParentModel(Block block, String prefix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.f_41373_.get(block);
        if (item != null) {
            ResourceLocation rl = ForgeRegistries.BLOCKS.getKey((Object)block);
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(new ResourceLocation(rl.m_135827_(), "block/" + prefix + rl.m_135815_())), itemModels);
        }
    }

    public String m_6055_() {
        return "Productive Trees Blockstate and Model generator";
    }

    static class ModelGenerator {
        Consumer<BlockStateGenerator> blockStateOutput;
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;
        static ModelTemplate crateModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/base_crate")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125875_, TextureSlot.f_125872_, TextureSlot.f_125856_});

        ModelGenerator() {
        }

        protected void registerStatesAndModels(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
            this.blockStateOutput = blockStateOutput;
            this.modelOutput = modelOutput;
            HashMap<ResourceLocation, BlockStateGenerator> hiveBlockStates = new HashMap<ResourceLocation, BlockStateGenerator>();
            TreeFinder.trees.forEach((id, treeObject) -> {
                this.createSapling((TreeObject)treeObject);
                this.createBaseBlock(TreeUtil.getBlock(id, "_leaves"), "leaves/" + treeObject.getStyle().leafStyle());
                if (treeObject.hasFruit()) {
                    this.createFruitBlock((TreeObject)treeObject);
                }
                if (treeObject.getId().m_135815_().equals("cinnamon")) {
                    this.createCrate((TreeObject)treeObject, new ResourceLocation("productivetrees", "cinnamon"));
                }
                new WoodProvider().logWithHorizontal(treeObject.getStyle().woodStyle(), TreeUtil.getBlock(id, "_log"), false).wood(treeObject.getStyle().woodStyle(), TreeUtil.getBlock(id, "_wood"), false);
                new WoodProvider().logWithHorizontal(treeObject.getStyle().woodStyle(), TreeUtil.getBlock(id, "_stripped_log"), true).wood(treeObject.getStyle().woodStyle(), TreeUtil.getBlock(id, "_stripped_wood"), true);
                this.createBaseBlock(TreeUtil.getBlock(id, "_planks"), "planks/" + treeObject.getStyle().plankStyle());
                this.createStairsBlock((WoodObject)treeObject);
                this.createSlabBlock((WoodObject)treeObject);
                this.createPressurePlateBlock((WoodObject)treeObject);
                this.createButtonBlock((WoodObject)treeObject);
                this.createFenceGateBlock((WoodObject)treeObject);
                this.createFenceBlock((WoodObject)treeObject);
                this.createDoorBlock((WoodObject)treeObject);
                this.createTrapdoorBlock((WoodObject)treeObject);
                this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_bookshelf"), new ResourceLocation("productivetrees", "block/bookshelf/" + treeObject.getStyle().plankStyle())));
                this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_sign"), new ResourceLocation("productivetrees", "block/sign/" + treeObject.getStyle().plankStyle())));
                this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_wall_sign"), new ResourceLocation("productivetrees", "block/sign/" + treeObject.getStyle().plankStyle())));
                this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_hanging_sign"), new ResourceLocation("productivetrees", "block/sign/hanging_" + treeObject.getStyle().plankStyle())));
                this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(TreeUtil.getBlock(id, "_wall_hanging_sign"), new ResourceLocation("productivetrees", "block/sign/hanging_" + treeObject.getStyle().plankStyle())));
                if (treeObject.getStyle().hiveStyle() != null) {
                    Block hive = (Block)ForgeRegistries.BLOCKS.getValue(treeObject.getId().m_247266_(p -> "advanced_" + p + "_beehive"));
                    Block box = (Block)ForgeRegistries.BLOCKS.getValue(treeObject.getId().m_247266_(p -> "expansion_box_" + p));
                    cy.jdkdigital.productivebees.datagen.BlockstateProvider.generateModels((Block)hive, (Block)box, (String)id.m_135815_(), (HiveType)new HiveType(false, treeObject.getPlankColor(), treeObject.getStyle().hiveStyle(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{TreeUtil.getBlock(id, "_planks")})), (Map)hiveBlockStates, this.modelOutput);
                }
            });
            this.createBaseModels();
            hiveBlockStates.forEach((resourceLocation, stateGenerator) -> this.blockStateOutput.accept((BlockStateGenerator)stateGenerator));
        }

        private void createSapling(TreeObject treeObject) {
            Item item;
            Block block = TreeUtil.getBlock(treeObject.getId(), "_sapling");
            Block pottedBlock = TreeUtil.getBlock(treeObject.getId(), "_potted_sapling");
            String baseSapling = "";
            if (treeObject.hasFruit()) {
                baseSapling = "fruiting_";
            }
            if ((item = block.m_5456_()) != Items.f_41852_) {
                this.modelOutput.accept(ModelLocationUtils.m_125571_((Item)item), (Supplier<JsonElement>)new DelegatedModel(new ResourceLocation("productivetrees", "item/sapling/base_" + baseSapling + treeObject.getStyle().saplingStyle())));
            }
            this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(pottedBlock, new ResourceLocation("productivetrees", "block/sapling/base_potted_sapling_" + treeObject.getStyle().saplingStyle())));
            this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(block, new ResourceLocation("productivetrees", "block/sapling/base_" + baseSapling + treeObject.getStyle().saplingStyle())));
        }

        private void createCrate(TreeObject treeObject, Block block) {
            if (treeObject.getStyle().crateStyle() == null) {
                throw new RuntimeException(treeObject.getId() + " is missing a crate style");
            }
            ResourceLocation top = ForgeRegistries.BLOCKS.getKey((Object)block).m_247266_(p -> "block/crate/" + p.replace("_crate", ""));
            TextureMapping textureMapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, new ResourceLocation("productivetrees", "block/crate/" + treeObject.getStyle().crateStyle() + "/side")).m_125758_(TextureSlot.f_125872_, new ResourceLocation("productivetrees", "block/crate/" + treeObject.getStyle().crateStyle() + "/top")).m_125758_(TextureSlot.f_125871_, new ResourceLocation("productivetrees", "block/crate/" + treeObject.getStyle().crateStyle() + "/bottom")).m_125758_(TextureSlot.f_125856_, top);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)crateModel.m_125612_(ForgeRegistries.BLOCKS.getKey((Object)block).m_247266_(p -> "block/crates/" + p), textureMapping, this.modelOutput))));
        }

        static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation resourceLocation) {
            return MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)resourceLocation));
        }

        static BlockStateGenerator createAxisAlignedPillarBlock(Block block, ResourceLocation resourceLocation) {
            return MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)resourceLocation)).m_125271_(ModelGenerator.createRotatedPillar());
        }

        static BlockStateGenerator createRotatedPillarWithHorizontalVariant(Block p_124925_, ResourceLocation p_124926_, ResourceLocation resourceLocation) {
            return MultiVariantGenerator.m_125254_((Block)p_124925_).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125329_((Comparable)Direction.Axis.Y, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)p_124926_)).m_125329_((Comparable)Direction.Axis.Z, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)resourceLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.Axis.X, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)resourceLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)));
        }

        private static PropertyDispatch createRotatedPillar() {
            return PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125329_((Comparable)Direction.Axis.Y, Variant.m_125501_()).m_125329_((Comparable)Direction.Axis.Z, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.Axis.X, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90));
        }

        private void createBaseBlock(Block block, String baseName) {
            this.blockStateOutput.accept((BlockStateGenerator)ModelGenerator.createSimpleBlock(block, new ResourceLocation("productivetrees", "block/" + baseName)));
        }

        private void createFruitBlock(TreeObject treeObject) {
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)TreeUtil.getBlock(treeObject.getId(), "_fruit")).m_125271_(PropertyDispatch.m_125294_((Property)ProductiveFruitBlock.getAgeProperty()).m_125335_(age -> {
                String fruitStyle = treeObject.getFruit().style();
                if (fruitStyle.equals("default")) {
                    ModelTemplate template = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/fruit/base_fruit")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_, TextureSlot.f_125883_});
                    return Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)template.m_125612_(new ResourceLocation("productivetrees", "block/fruit/" + treeObject.getId().m_135815_() + "/stage_" + age), new TextureMapping().m_125758_(TextureSlot.f_125867_, new ResourceLocation("productivetrees", "block/leaves/" + treeObject.getStyle().leafStyle())).m_125758_(TextureSlot.f_125883_, new ResourceLocation("productivetrees", "block/fruit/" + treeObject.getId().m_135815_() + "/stage_" + age)), this.modelOutput));
                }
                ModelTemplate template = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/fruit/" + fruitStyle + "/fruit_" + age)), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_});
                return Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)template.m_125612_(new ResourceLocation("productivetrees", "block/fruit/" + treeObject.getId().m_135815_() + "/" + age), new TextureMapping().m_125758_(TextureSlot.f_125867_, new ResourceLocation("productivetrees", "block/leaves/" + treeObject.getStyle().leafStyle())), this.modelOutput));
            })));
            this.createCrate(treeObject, treeObject.getFruit().fruitItem());
        }

        private void createCrate(TreeObject treeObject, ResourceLocation item) {
            ResourceLocation roastedCratePath;
            ResourceLocation cratePath = new ResourceLocation("productivetrees", item.m_247266_(p -> p.equals("apple") ? "red_delicious_apple_crate" : p + "_crate").m_135815_());
            if (TreeRegistrator.CRATED_CROPS.contains(cratePath) && !treeObject.getId().m_135815_().contains("copper_beech") && !treeObject.getId().m_135815_().contains("purple_blackthorn")) {
                this.createCrate(treeObject, (Block)ForgeRegistries.BLOCKS.getValue(cratePath));
            }
            if (TreeRegistrator.CRATED_CROPS.contains(roastedCratePath = item.m_247266_(p -> "roasted_" + p + "_crate")) && !treeObject.getId().m_135815_().contains("copper_beech") && !treeObject.getId().m_135815_().contains("purple_blackthorn")) {
                this.createCrate(treeObject, (Block)ForgeRegistries.BLOCKS.getValue(roastedCratePath));
            }
        }

        private void createStairsBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_stairs");
            ResourceLocation stairs = new ResourceLocation("productivetrees", "block/stairs/" + treeObject.getStyle().plankStyle() + "_stairs");
            ResourceLocation stairsInner = new ResourceLocation("productivetrees", "block/stairs/" + treeObject.getStyle().plankStyle() + "_stairs_inner");
            ResourceLocation stairsOuter = new ResourceLocation("productivetrees", "block/stairs/" + treeObject.getStyle().plankStyle() + "_stairs_outer");
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125299_((Property)HorizontalDirectionalBlock.f_54117_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61398_).m_125389_((facing, half, shape) -> {
                int yRotValue = (int)facing.m_122427_().m_122435_();
                if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                    yRotValue += 270;
                }
                if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                    yRotValue += 90;
                }
                boolean uvLock = (yRotValue %= 360) != 0 || half == Half.TOP;
                VariantProperties.Rotation yRot = switch (yRotValue) {
                    case 90 -> VariantProperties.Rotation.R90;
                    case 180 -> VariantProperties.Rotation.R180;
                    case 270 -> VariantProperties.Rotation.R270;
                    default -> VariantProperties.Rotation.R0;
                };
                Variant variant = Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)));
                if (half != Half.BOTTOM) {
                    variant.m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180);
                }
                if (!yRot.equals((Object)VariantProperties.Rotation.R0)) {
                    variant.m_125511_(VariantProperties.f_125519_, (Object)yRot);
                }
                if (uvLock) {
                    variant.m_125511_(VariantProperties.f_125521_, (Object)true);
                }
                return variant;
            })));
        }

        private void createSlabBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_slab");
            ResourceLocation slab = new ResourceLocation("productivetrees", "block/slab/" + treeObject.getStyle().plankStyle() + "_slab");
            ResourceLocation planks = new ResourceLocation("productivetrees", "block/planks/" + treeObject.getStyle().plankStyle());
            ResourceLocation slabTop = new ResourceLocation("productivetrees", "block/slab/" + treeObject.getStyle().plankStyle() + "_slab_top");
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61397_).m_125335_(slabType -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(slabType == SlabType.BOTTOM ? slab : (slabType == SlabType.TOP ? slabTop : planks))))));
        }

        private void createPressurePlateBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_pressure_plate");
            ResourceLocation plate = new ResourceLocation("productivetrees", "block/pressure_plate/" + treeObject.getStyle().plankStyle() + "_pressure_plate");
            ResourceLocation plateDown = new ResourceLocation("productivetrees", "block/pressure_plate/" + treeObject.getStyle().plankStyle() + "_pressure_plate_down");
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61448_).m_125335_(powered -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(powered != false ? plateDown : plate)))));
        }

        private void createButtonBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_button");
            ResourceLocation button = new ResourceLocation("productivetrees", "block/button/" + treeObject.getStyle().plankStyle() + "_button");
            ResourceLocation buttonPressed = new ResourceLocation("productivetrees", "block/button/" + treeObject.getStyle().plankStyle() + "_button_pressed");
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125299_((Property)ButtonBlock.f_54117_, (Property)ButtonBlock.f_53179_, (Property)ButtonBlock.f_51045_).m_125389_((facing, face, powered) -> {
                VariantProperties.Rotation yRot;
                Variant variant = Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(powered != false ? buttonPressed : button));
                int yRotValue = (int)(face == AttachFace.CEILING ? facing : facing.m_122424_()).m_122435_();
                switch (yRotValue) {
                    case 90: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R90;
                        break;
                    }
                    case 180: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R180;
                        break;
                    }
                    case 270: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R270;
                        break;
                    }
                    default: {
                        VariantProperties.Rotation rotation = yRot = VariantProperties.Rotation.R0;
                    }
                }
                if (face != AttachFace.FLOOR) {
                    variant.m_125511_(VariantProperties.f_125518_, (Object)(face == AttachFace.WALL ? VariantProperties.Rotation.R90 : VariantProperties.Rotation.R180));
                }
                if (!yRot.equals((Object)VariantProperties.Rotation.R0)) {
                    variant.m_125511_(VariantProperties.f_125519_, (Object)yRot);
                }
                if (face == AttachFace.WALL) {
                    variant.m_125511_(VariantProperties.f_125521_, (Object)true);
                }
                return variant;
            })));
        }

        private void createFenceGateBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_fence_gate");
            ResourceLocation fenceGate = new ResourceLocation("productivetrees", "block/fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate");
            ResourceLocation fenceGateOpen = new ResourceLocation("productivetrees", "block/fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate_open");
            ResourceLocation fenceGateWall = new ResourceLocation("productivetrees", "block/fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate_wall");
            ResourceLocation fenceGateWallOpen = new ResourceLocation("productivetrees", "block/fence_gate/" + treeObject.getStyle().plankStyle() + "_fence_gate_wall_open");
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_(PropertyDispatch.m_125299_((Property)FenceGateBlock.f_54117_, (Property)FenceGateBlock.f_53343_, (Property)FenceGateBlock.f_53341_).m_125389_((facing, inWall, open) -> {
                VariantProperties.Rotation yRot;
                Variant variant = Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)(open.booleanValue() ? (inWall.booleanValue() ? fenceGateWallOpen : fenceGateOpen) : (inWall != false ? fenceGateWall : fenceGate)));
                int yRotValue = (int)facing.m_122435_();
                switch (yRotValue) {
                    case 90: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R90;
                        break;
                    }
                    case 180: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R180;
                        break;
                    }
                    case 270: {
                        VariantProperties.Rotation rotation = VariantProperties.Rotation.R270;
                        break;
                    }
                    default: {
                        VariantProperties.Rotation rotation = yRot = VariantProperties.Rotation.R0;
                    }
                }
                if (!yRot.equals((Object)VariantProperties.Rotation.R0)) {
                    variant.m_125511_(VariantProperties.f_125519_, (Object)yRot);
                }
                variant.m_125511_(VariantProperties.f_125521_, (Object)true);
                return variant;
            })));
        }

        private void createFenceBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_fence");
            ResourceLocation fencePost = new ResourceLocation("productivetrees", "block/fence/" + treeObject.getStyle().plankStyle() + "_fence_post");
            ResourceLocation fenceSide = new ResourceLocation("productivetrees", "block/fence/" + treeObject.getStyle().plankStyle() + "_fence_side");
            this.blockStateOutput.accept((BlockStateGenerator)MultiPartGenerator.m_125204_((Block)block).m_125218_(Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fencePost)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSide).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSide).m_125511_(VariantProperties.f_125521_, (Object)true).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSide).m_125511_(VariantProperties.f_125521_, (Object)true).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSide).m_125511_(VariantProperties.f_125521_, (Object)true).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)));
        }

        private void createDoorBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_door");
            ResourceLocation bottomLeft = new ResourceLocation("productivetrees", "block/door/" + treeObject.getStyle().doorStyle() + "_bottom_left");
            ResourceLocation bottomLeftOpen = new ResourceLocation("productivetrees", "block/door/" + treeObject.getStyle().doorStyle() + "_bottom_left_open");
            ResourceLocation bottomRight = new ResourceLocation("productivetrees", "block/door/" + treeObject.getStyle().doorStyle() + "_bottom_right");
            ResourceLocation bottomRightOpen = new ResourceLocation("productivetrees", "block/door/" + treeObject.getStyle().doorStyle() + "_bottom_right_open");
            ResourceLocation topLeft = new ResourceLocation("productivetrees", "block/door/" + treeObject.getStyle().doorStyle() + "_top_left");
            ResourceLocation topLeftOpen = new ResourceLocation("productivetrees", "block/door/" + treeObject.getStyle().doorStyle() + "_top_left_open");
            ResourceLocation topRight = new ResourceLocation("productivetrees", "block/door/" + treeObject.getStyle().doorStyle() + "_top_right");
            ResourceLocation topRightOpen = new ResourceLocation("productivetrees", "block/door/" + treeObject.getStyle().doorStyle() + "_top_right_open");
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_(ModelGenerator.configureDoorHalf(ModelGenerator.configureDoorHalf((PropertyDispatch.C4<Direction, DoubleBlockHalf, DoorHingeSide, Boolean>)PropertyDispatch.m_125303_((Property)DoorBlock.f_52726_, (Property)DoorBlock.f_52730_, (Property)DoorBlock.f_52728_, (Property)DoorBlock.f_52727_), DoubleBlockHalf.LOWER, bottomLeft, bottomLeftOpen, bottomRight, bottomRightOpen), DoubleBlockHalf.UPPER, topLeft, topLeftOpen, topRight, topRightOpen)));
        }

        private static PropertyDispatch.C4<Direction, DoubleBlockHalf, DoorHingeSide, Boolean> configureDoorHalf(PropertyDispatch.C4<Direction, DoubleBlockHalf, DoorHingeSide, Boolean> p_236305_, DoubleBlockHalf half, ResourceLocation left, ResourceLocation leftOpen, ResourceLocation right, ResourceLocation rightOpen) {
            return p_236305_.m_125429_((Comparable)Direction.EAST, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)left)).m_125429_((Comparable)Direction.EAST, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)right)).m_125429_((Comparable)Direction.EAST, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)leftOpen).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.EAST, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)rightOpen).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.SOUTH, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)left).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.SOUTH, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)right).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.SOUTH, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)leftOpen).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.SOUTH, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)rightOpen)).m_125429_((Comparable)Direction.WEST, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)left).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.WEST, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)right).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.WEST, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)leftOpen).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.WEST, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)rightOpen).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.NORTH, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)left).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.NORTH, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)right).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.NORTH, (Comparable)half, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)leftOpen)).m_125429_((Comparable)Direction.NORTH, (Comparable)half, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)rightOpen).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180));
        }

        private void createTrapdoorBlock(WoodObject treeObject) {
            Block block = TreeUtil.getBlock(treeObject.getId(), "_trapdoor");
            ResourceLocation top = new ResourceLocation("productivetrees", "block/trapdoor/" + treeObject.getStyle().doorStyle() + "_top");
            ResourceLocation bottom = new ResourceLocation("productivetrees", "block/trapdoor/" + treeObject.getStyle().doorStyle() + "_bottom");
            ResourceLocation open = new ResourceLocation("productivetrees", "block/trapdoor/" + treeObject.getStyle().doorStyle() + "_open");
            this.blockStateOutput.accept(ModelGenerator.createTrapdoor(block, top, bottom, open));
        }

        private static BlockStateGenerator createTrapdoor(Block block, ResourceLocation top, ResourceLocation bottom, ResourceLocation open) {
            return MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)PropertyDispatch.m_125299_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61446_).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottom)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottom).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottom).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottom).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)top)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)top).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)top).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)top).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)open)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)open).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)open).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)open).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)open).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)open).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R0)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)open).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)open).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)));
        }

        private void createBaseModels() {
            WoodSet.STYLES.forEach((name, style) -> {
                String modelPrefix = TreeUtil.isTranslucentTree(name) ? "translucent_" : "";
                ModelTemplate planksModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/planks/" + modelPrefix + "base_planks")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_});
                ModelTemplate buttonModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/button/" + modelPrefix + "base_button")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate buttonInventoryModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/button/" + modelPrefix + "base_button_inventory")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate buttonPressedModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/button/" + modelPrefix + "base_button_pressed")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate fenceInventoryModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/fence/" + modelPrefix + "base_fence_inventory")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate fencePostModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/fence/" + modelPrefix + "base_fence_post")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate fenceSideModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/fence/" + modelPrefix + "base_fence_side")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate fenceGateModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/fence_gate/" + modelPrefix + "base_fence_gate")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate fenceGateOpenModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/fence_gate/" + modelPrefix + "base_fence_gate_open")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate fenceGateWallModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/fence_gate/" + modelPrefix + "base_fence_gate_wall")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate fenceGateWallOpenModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/fence_gate/" + modelPrefix + "base_fence_gate_wall_open")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate pressurePlateModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/pressure_plate/" + modelPrefix + "base_pressure_plate")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate pressurePlateDownModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/pressure_plate/" + modelPrefix + "base_pressure_plate_down")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate slabModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/slab/" + modelPrefix + "base_slab")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate slabTopModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/slab/" + modelPrefix + "base_slab_top")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate stairsModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/stairs/" + modelPrefix + "base_stairs")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate stairsInnerModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/stairs/" + modelPrefix + "base_stairs_inner")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate stairsOuterModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/stairs/" + modelPrefix + "base_stairs_outer")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate leavesModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/leaves/" + modelPrefix + "base_leaves")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_});
                ModelTemplate logModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/log/" + modelPrefix + "base_log")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125870_, TextureSlot.f_125875_});
                ModelTemplate logHorizontalModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/log/" + modelPrefix + "base_log_horizontal")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125870_, TextureSlot.f_125875_});
                ModelTemplate cubeColumnModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/" + modelPrefix + "cube_column")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125870_, TextureSlot.f_125875_});
                ModelTemplate cubeColumnHorizontalModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/" + modelPrefix + "cube_column_horizontal")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125870_, TextureSlot.f_125875_});
                ModelTemplate doorBottomLeftModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/door/" + modelPrefix + "bottom_left")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_});
                ModelTemplate doorBottomLeftOpenModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/door/" + modelPrefix + "bottom_left_open")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_});
                ModelTemplate doorBottomRightModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/door/" + modelPrefix + "bottom_right")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_});
                ModelTemplate doorBottomRightOpenModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/door/" + modelPrefix + "bottom_right_open")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_});
                ModelTemplate doorTopLeftModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/door/" + modelPrefix + "top_left")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_});
                ModelTemplate doorTopLeftOpenModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/door/" + modelPrefix + "top_left_open")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_});
                ModelTemplate doorTopRightModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/door/" + modelPrefix + "top_right")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_});
                ModelTemplate doorTopRightOpenModel = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/door/" + modelPrefix + "top_right_open")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_});
                ModelTemplate trapdoorBottom = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/trapdoor/" + modelPrefix + "template_orientable_trapdoor_bottom")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate trapdoorOpen = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/trapdoor/" + modelPrefix + "template_orientable_trapdoor_open")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate trapdoorTop = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/trapdoor/" + modelPrefix + "template_orientable_trapdoor_top")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125868_});
                ModelTemplate bookshelf = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/" + modelPrefix + "base_bookshelf")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125875_});
                ModelTemplate sign = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/sign/" + modelPrefix + "base_sign")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125869_});
                ModelTemplate hangingSign = new ModelTemplate(Optional.of(new ResourceLocation("productivetrees", "block/sign/" + modelPrefix + "base_sign")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125869_});
                TextureMapping plankTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125868_, new ResourceLocation("productivetrees", "block/planks/" + style.plankStyle())).m_125758_(TextureSlot.f_125867_, new ResourceLocation("productivetrees", "block/planks/" + style.plankStyle()));
                planksModel.m_125612_(new ResourceLocation("productivetrees", "block/planks/" + name), plankTextureMap, this.modelOutput);
                buttonModel.m_125612_(new ResourceLocation("productivetrees", "block/button/" + name + "_button"), plankTextureMap, this.modelOutput);
                buttonInventoryModel.m_125612_(new ResourceLocation("productivetrees", "block/button/" + name + "_button_inventory"), plankTextureMap, this.modelOutput);
                buttonPressedModel.m_125612_(new ResourceLocation("productivetrees", "block/button/" + name + "_button_pressed"), plankTextureMap, this.modelOutput);
                fenceInventoryModel.m_125612_(new ResourceLocation("productivetrees", "block/fence/" + name + "_fence_inventory"), plankTextureMap, this.modelOutput);
                fencePostModel.m_125612_(new ResourceLocation("productivetrees", "block/fence/" + name + "_fence_post"), plankTextureMap, this.modelOutput);
                fenceSideModel.m_125612_(new ResourceLocation("productivetrees", "block/fence/" + name + "_fence_side"), plankTextureMap, this.modelOutput);
                fenceGateModel.m_125612_(new ResourceLocation("productivetrees", "block/fence_gate/" + name + "_fence_gate"), plankTextureMap, this.modelOutput);
                fenceGateOpenModel.m_125612_(new ResourceLocation("productivetrees", "block/fence_gate/" + name + "_fence_gate_open"), plankTextureMap, this.modelOutput);
                fenceGateWallModel.m_125612_(new ResourceLocation("productivetrees", "block/fence_gate/" + name + "_fence_gate_wall"), plankTextureMap, this.modelOutput);
                fenceGateWallOpenModel.m_125612_(new ResourceLocation("productivetrees", "block/fence_gate/" + name + "_fence_gate_wall_open"), plankTextureMap, this.modelOutput);
                pressurePlateModel.m_125612_(new ResourceLocation("productivetrees", "block/pressure_plate/" + name + "_pressure_plate"), plankTextureMap, this.modelOutput);
                pressurePlateDownModel.m_125612_(new ResourceLocation("productivetrees", "block/pressure_plate/" + name + "_pressure_plate_down"), plankTextureMap, this.modelOutput);
                slabModel.m_125612_(new ResourceLocation("productivetrees", "block/slab/" + name + "_slab"), plankTextureMap, this.modelOutput);
                slabTopModel.m_125612_(new ResourceLocation("productivetrees", "block/slab/" + name + "_slab_top"), plankTextureMap, this.modelOutput);
                stairsModel.m_125612_(new ResourceLocation("productivetrees", "block/stairs/" + name + "_stairs"), plankTextureMap, this.modelOutput);
                stairsInnerModel.m_125612_(new ResourceLocation("productivetrees", "block/stairs/" + name + "_stairs_inner"), plankTextureMap, this.modelOutput);
                stairsOuterModel.m_125612_(new ResourceLocation("productivetrees", "block/stairs/" + name + "_stairs_outer"), plankTextureMap, this.modelOutput);
                TextureMapping leavesTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125867_, new ResourceLocation("productivetrees", "block/leaves/" + style.leafStyle()));
                leavesModel.m_125612_(new ResourceLocation("productivetrees", "block/leaves/" + name), leavesTextureMap, this.modelOutput);
                TextureMapping logTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125870_, new ResourceLocation("productivetrees", "block/log_top/" + style.woodStyle())).m_125758_(TextureSlot.f_125875_, new ResourceLocation("productivetrees", "block/log/" + style.woodStyle()));
                logModel.m_125612_(new ResourceLocation("productivetrees", "block/log/" + name + "_log"), logTextureMap, this.modelOutput);
                logHorizontalModel.m_125612_(new ResourceLocation("productivetrees", "block/log/" + name + "_log_horizontal"), logTextureMap, this.modelOutput);
                TextureMapping strippedLogTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125870_, new ResourceLocation("productivetrees", "block/stripped/" + style.woodStyle() + "_top")).m_125758_(TextureSlot.f_125875_, new ResourceLocation("productivetrees", "block/stripped/" + style.woodStyle()));
                cubeColumnModel.m_125612_(new ResourceLocation("productivetrees", "block/log/" + name + "_stripped_log"), strippedLogTextureMap, this.modelOutput);
                cubeColumnHorizontalModel.m_125612_(new ResourceLocation("productivetrees", "block/log/" + name + "_stripped_log_horizontal"), strippedLogTextureMap, this.modelOutput);
                TextureMapping strippedWoodTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125870_, new ResourceLocation("productivetrees", "block/stripped/" + style.woodStyle())).m_125758_(TextureSlot.f_125875_, new ResourceLocation("productivetrees", "block/stripped/" + style.woodStyle()));
                cubeColumnModel.m_125612_(new ResourceLocation("productivetrees", "block/log/" + name + "_stripped_wood"), strippedWoodTextureMap, this.modelOutput);
                TextureMapping woodTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125870_, new ResourceLocation("productivetrees", "block/log/" + style.woodStyle())).m_125758_(TextureSlot.f_125875_, new ResourceLocation("productivetrees", "block/log/" + style.woodStyle()));
                cubeColumnModel.m_125612_(new ResourceLocation("productivetrees", "block/log/" + name + "_wood"), woodTextureMap, this.modelOutput);
                TextureMapping doorTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125872_, new ResourceLocation("productivetrees", "block/door/" + style.doorStyle() + "_top")).m_125758_(TextureSlot.f_125871_, new ResourceLocation("productivetrees", "block/door/" + style.doorStyle() + "_bottom"));
                doorBottomLeftModel.m_125612_(new ResourceLocation("productivetrees", "block/door/" + name + "_bottom_left"), doorTextureMap, this.modelOutput);
                doorBottomLeftOpenModel.m_125612_(new ResourceLocation("productivetrees", "block/door/" + name + "_bottom_left_open"), doorTextureMap, this.modelOutput);
                doorBottomRightModel.m_125612_(new ResourceLocation("productivetrees", "block/door/" + name + "_bottom_right"), doorTextureMap, this.modelOutput);
                doorBottomRightOpenModel.m_125612_(new ResourceLocation("productivetrees", "block/door/" + name + "_bottom_right_open"), doorTextureMap, this.modelOutput);
                doorTopLeftModel.m_125612_(new ResourceLocation("productivetrees", "block/door/" + name + "_top_left"), doorTextureMap, this.modelOutput);
                doorTopLeftOpenModel.m_125612_(new ResourceLocation("productivetrees", "block/door/" + name + "_top_left_open"), doorTextureMap, this.modelOutput);
                doorTopRightModel.m_125612_(new ResourceLocation("productivetrees", "block/door/" + name + "_top_right"), doorTextureMap, this.modelOutput);
                doorTopRightOpenModel.m_125612_(new ResourceLocation("productivetrees", "block/door/" + name + "_top_right_open"), doorTextureMap, this.modelOutput);
                TextureMapping trapdoorTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125868_, new ResourceLocation("productivetrees", "block/trapdoor/" + style.doorStyle()));
                trapdoorBottom.m_125612_(new ResourceLocation("productivetrees", "block/trapdoor/" + name + "_bottom"), trapdoorTextureMap, this.modelOutput);
                trapdoorOpen.m_125612_(new ResourceLocation("productivetrees", "block/trapdoor/" + name + "_open"), trapdoorTextureMap, this.modelOutput);
                trapdoorTop.m_125612_(new ResourceLocation("productivetrees", "block/trapdoor/" + name + "_top"), trapdoorTextureMap, this.modelOutput);
                TextureMapping bookshelfTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125875_, new ResourceLocation("productivetrees", "block/planks/" + style.plankStyle()));
                bookshelf.m_125612_(new ResourceLocation("productivetrees", "block/bookshelf/" + name), bookshelfTextureMap, this.modelOutput);
                TextureMapping signTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125868_, new ResourceLocation("productivetrees", "block/planks/" + style.plankStyle()));
                TextureMapping hangingSignTextureMap = new TextureMapping().m_125758_(TextureSlot.f_125868_, new ResourceLocation("productivetrees", "block/stripped/" + style.plankStyle()));
                sign.m_125612_(new ResourceLocation("productivetrees", "block/sign/" + name), signTextureMap, this.modelOutput);
                hangingSign.m_125612_(new ResourceLocation("productivetrees", "block/sign/hanging_" + name), hangingSignTextureMap, this.modelOutput);
            });
        }

        class WoodProvider {
            public WoodProvider wood(String style, Block block, boolean stripped) {
                ModelGenerator.this.blockStateOutput.accept(ModelGenerator.createAxisAlignedPillarBlock(block, new ResourceLocation("productivetrees", stripped ? "block/log/" + style + "_stripped_wood" : "block/log/" + style + "_wood")));
                return this;
            }

            public WoodProvider logWithHorizontal(String style, Block block, boolean stripped) {
                return this.logWithHorizontal(style, block, stripped, "log");
            }

            public WoodProvider logWithHorizontal(String style, Block block, boolean stripped, String type) {
                ResourceLocation rLoc = new ResourceLocation("productivetrees", stripped ? "block/log/" + style + "_stripped_" + type : "block/log/" + style + "_" + type);
                ResourceLocation rLocHor = new ResourceLocation("productivetrees", stripped ? "block/log/" + style + "_stripped_" + type + "_horizontal" : "block/log/" + style + "_" + type + "_horizontal");
                ModelGenerator.this.blockStateOutput.accept(ModelGenerator.createRotatedPillarWithHorizontalVariant(block, new ResourceLocation("productivetrees", rLoc.m_135815_()), new ResourceLocation("productivetrees", rLocHor.m_135815_())));
                return this;
            }
        }
    }
}

