/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivetrees.inventory.SawmillContainer;
import cy.jdkdigital.productivetrees.recipe.SawmillRecipe;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SawmillBlockEntity
extends CapabilityBlockEntity
implements MenuProvider {
    protected int tickCounter = 0;
    public int tickRate = 10;
    public int recipeTime = 200;
    public int progress = 0;
    private ItemStack buffer = ItemStack.f_41583_;
    public static int SLOT_IN = 0;
    public static int SLOT_OUT = 1;
    public static int SLOT_SECONDARY = 2;
    public static int SLOT_TERTIARY = 3;
    private final LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.BlockEntityItemStackHandler(4, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (this.isInputSlotItem(slot, stack)) {
                return true;
            }
            return slot != SLOT_IN;
        }

        public boolean isInputSlotItem(int slot, ItemStack stack) {
            if (slot == SLOT_IN && SawmillBlockEntity.this.canProcess(stack)) {
                ItemStack currentOutStack = this.getStackInSlot(slot);
                return currentOutStack.m_41619_() || currentOutStack.m_41613_() < currentOutStack.m_41741_() && ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)currentOutStack);
            }
            return false;
        }

        public boolean isInputSlot(int slot) {
            return slot == SLOT_IN;
        }

        public boolean isInsertableSlot(int slot) {
            return slot == SLOT_IN;
        }

        public int[] getOutputSlots() {
            return new int[]{SLOT_OUT, SLOT_SECONDARY, SLOT_TERTIARY};
        }
    });

    private boolean canProcess(ItemStack stack) {
        SawmillRecipe recipe = TreeUtil.getSawmillRecipe(this.f_58857_, stack);
        return recipe != null;
    }

    public SawmillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TreeRegistrator.SAWMILL_BLOCK_ENTITY.get(), pos, state);
    }

    public Component m_7755_() {
        return Component.m_237115_((String)((Block)TreeRegistrator.SAWMILL.get()).m_7705_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SawmillBlockEntity blockEntity) {
        if (++blockEntity.tickCounter % blockEntity.tickRate == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockEntity.inventoryHandler.ifPresent(inv -> {
                ItemStack log = inv.getStackInSlot(SLOT_IN);
                ItemStack output = inv.getStackInSlot(SLOT_OUT);
                if (!blockEntity.buffer.m_41619_() && inv.insertItem(SLOT_OUT, blockEntity.buffer.m_41777_(), true).m_41619_()) {
                    inv.insertItem(SLOT_OUT, blockEntity.buffer.m_41777_(), false);
                    blockEntity.buffer = ItemStack.f_41583_;
                } else if (!log.m_41619_() && (output.m_41619_() || output.m_41613_() < output.m_41741_())) {
                    blockEntity.progress += blockEntity.tickRate;
                    if (blockEntity.progress >= blockEntity.recipeTime) {
                        SawmillRecipe recipe = TreeUtil.getSawmillRecipe(level, log);
                        if (recipe != null) {
                            ItemStack leftOver = inv.insertItem(SLOT_OUT, recipe.planks.m_41777_(), false);
                            if (!leftOver.m_41619_()) {
                                blockEntity.buffer = leftOver;
                            }
                            if (!recipe.secondary.m_41619_()) {
                                ItemStack tLeftover = inv.insertItem(SLOT_SECONDARY, recipe.secondary.m_41777_(), false);
                                if (!recipe.tertiary.m_41619_()) {
                                    inv.insertItem(SLOT_TERTIARY, recipe.tertiary.m_41777_(), false);
                                } else if (!tLeftover.m_41619_()) {
                                    inv.insertItem(SLOT_TERTIARY, tLeftover, false);
                                }
                            }
                            log.m_41774_(1);
                        }
                        blockEntity.progress = 0;
                    }
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new SawmillContainer(windowId, playerInventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        this.progress = tag.m_128451_("RecipeProgress");
    }

    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        tag.m_128405_("RecipeProgress", this.progress);
    }
}

