/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeEffect
implements INBTSerializable<CompoundTag> {
    private Map<MobEffect, Integer> effects = new HashMap<MobEffect, Integer>();

    public BeeEffect(Map<MobEffect, Integer> effects) {
        this.effects = effects;
    }

    public BeeEffect(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public Map<MobEffect, Integer> getEffects() {
        return this.effects;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("i", this.effects.size());
        this.getEffects().forEach((effect, duration) -> {
            CompoundTag effectTag = new CompoundTag();
            effectTag.m_128359_("effect", "" + ForgeRegistries.MOB_EFFECTS.getKey(effect));
            effectTag.m_128405_("duration", duration.intValue());
            tag.m_128365_("effect_" + (tag.m_128440_() - 1), (Tag)effectTag);
        });
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.effects = new HashMap<MobEffect, Integer>();
        IntStream.range(0, tag.m_128451_("i")).forEach(i -> {
            CompoundTag effectTag = tag.m_128469_("effect_" + i);
            String effectName = effectTag.m_128461_("effect");
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectName));
            this.effects.put(effect, effectTag.m_128451_("duration"));
        });
    }
}

