/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.top;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.CanvasBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.CanvasExpansionBoxBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.IRecipeProcessingBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class TopPlugin
implements Function<ITheOneProbe, Void> {
    MutableComponent formattedName = Component.m_237113_((String)"Productive Bees").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC);

    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerEntityDisplayOverride((probeMode, probeInfo, player, level, entity, iProbeHitEntityData) -> {
            if (entity instanceof ProductiveBee) {
                ProductiveBee bee = (ProductiveBee)entity;
                if (probeMode.equals((Object)ProbeMode.EXTENDED)) {
                    probeInfo.horizontal().entity(entity).vertical().text(CompoundText.create().name(entity.m_7755_())).text(CompoundText.create().style(TextStyleClass.MODNAME).text("Productive Bees"));
                    ArrayList<Component> list = new ArrayList<Component>();
                    BeeHelper.populateBeeInfoFromEntity(bee, list);
                    for (Component component : list) {
                        probeInfo.mcText(component);
                    }
                    probeInfo.text((Component)this.formattedName);
                    return true;
                }
            }
            return false;
        });
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
            IRecipeProcessingBlockEntity recipeProcessingBlockEntity;
            BlockEntity tileEntity = world.m_7702_(data.getPos());
            if (tileEntity instanceof SolitaryNestBlockEntity) {
                SolitaryNestBlockEntity nest = (SolitaryNestBlockEntity)tileEntity;
                probeInfo.horizontal().item(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).vertical().itemLabel(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).text(CompoundText.create().style(TextStyleClass.MODNAME).text("Productive Bees"));
                List<AdvancedBeehiveBlockEntityAbstract.Inhabitant> bees = nest.getBeeList();
                if (!bees.isEmpty()) {
                    probeInfo.text((Component)Component.m_237110_((String)"productivebees.top.solitary.bee", (Object[])new Object[]{bees.get((int)0).localizedName}));
                    if (bees.get((int)0).minOccupationTicks - bees.get((int)0).ticksInHive > 0) {
                        probeInfo.progress(Math.max(0, bees.get((int)0).minOccupationTicks - bees.get((int)0).ticksInHive), bees.get((int)0).minOccupationTicks);
                    }
                } else if (nest.getNestTickCooldown() > 0) {
                    probeInfo.text((Component)Component.m_237115_((String)"productivebees.top.solitary.repopulation_countdown"));
                    probeInfo.progress(nest.getNestTickCooldown() / 20, (Integer)ProductiveBeesConfig.GENERAL.nestSpawnCooldown.get() / 20);
                } else {
                    probeInfo.text((Component)Component.m_237115_((String)"productivebees.top.solitary.repopulation_countdown_inactive"));
                    if (nest.canRepopulate()) {
                        probeInfo.text((Component)Component.m_237115_((String)"productivebees.top.solitary.can_repopulate_true"));
                    } else {
                        probeInfo.text((Component)Component.m_237115_((String)"productivebees.top.solitary.can_repopulate_false"));
                    }
                }
                return true;
            }
            if (tileEntity instanceof CanvasBeehiveBlockEntity || tileEntity instanceof CanvasExpansionBoxBlockEntity) {
                Object style = blockState.m_60734_().m_7705_().replace("block.productivebees.advanced_", "").replace("_canvas_beehive", "");
                style = ((String)style).substring(0, 1).toUpperCase() + ((String)style).substring(1);
                probeInfo.text((Component)Component.m_237110_((String)"productivebees.information.canvas.style", (Object[])new Object[]{Component.m_237113_((String)style).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.WHITE));
                return true;
            }
            if (tileEntity instanceof IRecipeProcessingBlockEntity && (recipeProcessingBlockEntity = (IRecipeProcessingBlockEntity)tileEntity).getRecipeProgress() > 0) {
                probeInfo.horizontal().item(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).vertical().itemLabel(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).progress(recipeProcessingBlockEntity.getRecipeProgress() / 20, recipeProcessingBlockEntity.getProcessingTime(recipeProcessingBlockEntity.getCurrentRecipe()) / 20).text(CompoundText.create().style(TextStyleClass.MODNAME).text("Productive Bees"));
                return true;
            }
            ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
            if (registryName != null && registryName.m_135827_().equals("productivebees")) {
                probeInfo.horizontal().item(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).vertical().itemLabel(new ItemStack((ItemLike)blockState.m_60734_().m_5456_())).text((Component)this.formattedName);
                return true;
            }
            return false;
        });
        return null;
    }
}

