/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.util.Lazy;

public class BeeSpawningRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final Ingredient spawnItem;
    public final List<Lazy<BeeIngredient>> output;
    public final String biomes;
    public final TagKey<Biome> biomeKey;

    public BeeSpawningRecipe(ResourceLocation id, Ingredient ingredient, Ingredient spawnItem, List<Lazy<BeeIngredient>> output, String biomes) {
        this.id = id;
        this.ingredient = ingredient;
        this.spawnItem = spawnItem;
        this.output = output;
        this.biomes = biomes.replace("#", "");
        this.biomeKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(this.biomes));
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return false;
    }

    public boolean matches(ItemStack nest, ItemStack heldItem, Holder<Biome> biome, Level level) {
        return !(!this.ingredient.test(nest) || !heldItem.equals(ItemStack.f_41583_) && !this.spawnItem.test(heldItem) || !this.biomes.equals("any") && !biome.m_203656_(this.biomeKey));
    }

    @Nonnull
    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.BEE_SPAWNING.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.BEE_SPAWNING_TYPE.get();
    }

    public static class Serializer<T extends BeeSpawningRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"ingredient")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            Ingredient spawnItem = json.has("spawn_item") ? (GsonHelper.m_13885_((JsonObject)json, (String)"spawn_item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"spawn_item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"spawn_item"))) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HONEY_TREAT.get()});
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"results");
            ArrayList<Lazy<BeeIngredient>> output = new ArrayList<Lazy<BeeIngredient>>();
            jsonArray.forEach(el -> {
                JsonObject jsonObject = el.getAsJsonObject();
                String beeName = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"bee");
                Lazy beeIngredient = Lazy.of(BeeIngredientFactory.getIngredient(beeName));
                output.add(beeIngredient);
            });
            String biomes = "any";
            if (json.has("biomes")) {
                biomes = GsonHelper.m_13906_((JsonObject)json, (String)"biomes");
            }
            return this.factory.create(id, ingredient, spawnItem, output, biomes);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                Ingredient spawnItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                ArrayList<Lazy<BeeIngredient>> output = new ArrayList<Lazy<BeeIngredient>>();
                IntStream.range(0, buffer.readInt()).forEach(i -> {
                    BeeIngredient ing = BeeIngredient.fromNetwork(buffer);
                    output.add(Lazy.of(() -> ing));
                });
                return this.factory.create(id, ingredient, spawnItem, output, buffer.m_130277_());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee spawning recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((BeeSpawningRecipe)recipe).ingredient.m_43923_(buffer);
                ((BeeSpawningRecipe)recipe).spawnItem.m_43923_(buffer);
                buffer.writeInt(((BeeSpawningRecipe)recipe).output.size());
                for (Lazy<BeeIngredient> beeOutput : ((BeeSpawningRecipe)recipe).output) {
                    if (beeOutput.get() != null) {
                        ((BeeIngredient)beeOutput.get()).toNetwork(buffer);
                        continue;
                    }
                    ProductiveBees.LOGGER.error("Bee spawning recipe output missing " + ((BeeSpawningRecipe)recipe).m_6423_() + " - " + beeOutput);
                }
                buffer.m_130070_(((BeeSpawningRecipe)recipe).biomes);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee spawning recipe to packet. " + ((BeeSpawningRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeSpawningRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, List<Lazy<BeeIngredient>> var4, String var5);
        }
    }
}

