/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.network;

import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class UpdateBridgeTypePacket {
    public String bridgeType;

    public UpdateBridgeTypePacket(BridgeType bridgeType) {
        this.bridgeType = bridgeType.toString();
    }

    public UpdateBridgeTypePacket(FriendlyByteBuf buf) {
        this.bridgeType = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.bridgeType);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            if (!GeneralUtils.isHoldingPipeConnector((Player)sender)) {
                return;
            }
            TagUtils.setBridgeType(sender.m_21205_(), BridgeType.valueOf(this.bridgeType));
        });
        ctx.get().setPacketHandled(true);
    }
}

