/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui.buttons;

import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.network.NetworkHandler;
import com.heaser.pipeconnector.network.UpdateUtilizeExistingPipes;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class UtilizeExistingPipesButton
extends BaseButton {
    public UtilizeExistingPipesButton(ItemStack itemStack) {
        super(UtilizeExistingPipesButton.getInitialLabel(itemStack), 20, 20);
    }

    @Override
    public void onClick(Button clickedButton, ItemStack itemStack) {
        if (TagUtils.getUtilizeExistingPipes(itemStack)) {
            this.setLabel("item.pipe_connector.gui.button.off", ChatFormatting.RED);
            this.button.m_93666_(this.getLabel());
            TagUtils.setUtilizeExistingPipes(itemStack, false);
        } else {
            this.setLabel("item.pipe_connector.gui.button.on", ChatFormatting.GREEN);
            this.button.m_93666_(this.getLabel());
            TagUtils.setUtilizeExistingPipes(itemStack, true);
        }
        NetworkHandler.CHANNEL.sendToServer((Object)new UpdateUtilizeExistingPipes(TagUtils.getUtilizeExistingPipes(itemStack)));
    }

    @Override
    public boolean isActive(ItemStack itemStack) {
        return TagUtils.getBridgeType(itemStack).equals((Object)BridgeType.A_STAR);
    }

    @Override
    public List<Component> getTooltipList(ItemStack itemStack) {
        ArrayList<Component> tooltipList = new ArrayList<Component>();
        if (!this.isActive(itemStack)) {
            tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.button.tooltip.inactiveUtilizeExistingPipes"));
        } else {
            tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.button.tooltip.utilizeExistingPipesInfoPartOne"));
            tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.button.tooltip.utilizeExistingPipesInfoPartTwo"));
        }
        return tooltipList;
    }

    private static Component getInitialLabel(ItemStack itemStack) {
        if (TagUtils.getUtilizeExistingPipes(itemStack)) {
            return Component.m_237115_((String)"item.pipe_connector.gui.button.on").m_130940_(ChatFormatting.GREEN);
        }
        return Component.m_237115_((String)"item.pipe_connector.gui.button.off").m_130940_(ChatFormatting.RED);
    }
}

