/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.lucaargolo.mekanismcovers.MekanismCovers;
import dev.lucaargolo.mekanismcovers.mixed.TileEntityTransmitterMixed;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.FluidLogType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverItem
extends Item {
    public CoverItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext pContext) {
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos);
        BlockEntity entity = level.m_7702_(pos);
        ItemStack stack = pContext.m_43722_();
        Block coverBlock = CoverItem.getBlock(stack);
        if (coverBlock != null && entity instanceof TileEntityTransmitterMixed) {
            TileEntityTransmitterMixed transmitter = (TileEntityTransmitterMixed)entity;
            BlockState coverState = coverBlock.m_5573_(new BlockPlaceContext(pContext));
            if (!level.f_46443_) {
                if (transmitter.mekanism_covers$getCoverState() != null) {
                    MekanismCovers.removeCover(level, entity, state, pos, transmitter, true);
                }
                transmitter.mekanism_covers$setCoverState(coverState);
                entity.m_6596_();
                stack.m_41774_(1);
                if (!state.m_60819_().m_76178_()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateHelper.FLUID_LOGGED, (Comparable)FluidLogType.EMPTY));
                }
                level.m_7260_(pos, state, state, 3);
                level.m_5518_().m_7174_(pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (pLevel != null) {
            Block coverBlock = CoverItem.getBlock(pStack);
            if (coverBlock == null) {
                pTooltipComponents.add((Component)Component.m_237115_((String)"text.mekanismcovers.empty").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                pTooltipComponents.add((Component)coverBlock.m_49954_().m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
            }
        }
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        if (!stack.m_41782_() || !Objects.requireNonNull(stack.m_41783_()).m_128441_("CoverBlockItem")) {
            return null;
        }
        ItemStack coverBlockItem = ItemStack.m_41712_((CompoundTag)stack.m_41784_().m_128469_("CoverBlockItem"));
        Item item = coverBlockItem.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_();
        }
        return null;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                final Minecraft minecraft = Minecraft.m_91087_();
                return new BlockEntityWithoutLevelRenderer(minecraft.m_167982_(), minecraft.m_167973_()){

                    public void m_108829_(@NotNull ItemStack pStack, @NotNull ItemDisplayContext pDisplayContext, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
                        BakedModel coverStateModel;
                        BlockState coverState;
                        Block coverBlock = CoverItem.getBlock(pStack);
                        boolean transparent = true;
                        if (coverBlock == null) {
                            coverState = Blocks.f_50016_.m_49966_();
                            coverStateModel = minecraft.m_91304_().getModel(MekanismCovers.COVER_MODEL);
                            transparent = false;
                        } else {
                            coverState = coverBlock.m_49966_();
                            coverStateModel = minecraft.m_91289_().m_110910_(coverState);
                        }
                        BlockState state = Blocks.f_50016_.m_49966_();
                        BakedModel coverModel = minecraft.m_91304_().getModel(MekanismCovers.COVER_MODEL);
                        RenderType renderType = transparent ? RenderType.m_110470_((ResourceLocation)InventoryMenu.f_39692_) : RenderType.m_110446_((ResourceLocation)InventoryMenu.f_39692_);
                        VertexConsumer consumer = pBuffer.m_6299_(renderType);
                        PoseStack.Pose pose = pPoseStack.m_85850_();
                        RandomSource random = RandomSource.m_216327_();
                        for (Direction direction : Direction.values()) {
                            random.m_188584_(42L);
                            this.renderQuadList(coverState, pose, consumer, coverStateModel.getQuads(coverState, direction, random, ModelData.EMPTY, renderType), pPackedLight, pPackedOverlay);
                        }
                        random.m_188584_(42L);
                        this.renderQuadList(coverState, pose, consumer, coverStateModel.getQuads(coverState, null, random, ModelData.EMPTY, renderType), pPackedLight, pPackedOverlay);
                        if (coverStateModel != coverModel) {
                            for (Direction direction : Direction.values()) {
                                random.m_188584_(42L);
                                this.renderQuadList(state, pose, consumer, coverModel.getQuads(state, direction, random, ModelData.EMPTY, renderType), pPackedLight, pPackedOverlay);
                            }
                            random.m_188584_(42L);
                            this.renderQuadList(state, pose, consumer, coverModel.getQuads(state, null, random, ModelData.EMPTY, renderType), pPackedLight, pPackedOverlay);
                        }
                    }

                    private void renderQuadList(BlockState state, PoseStack.Pose pose, VertexConsumer consumer, List<BakedQuad> bakedQuads, int light, int overlay) {
                        for (BakedQuad quad : bakedQuads) {
                            float f2;
                            float f1;
                            float f;
                            if (minecraft.f_91073_ != null && quad.m_111304_()) {
                                BlockPos pos = BlockPos.f_121853_;
                                if (minecraft.f_91074_ != null) {
                                    pos = minecraft.f_91074_.m_20183_();
                                }
                                int i = minecraft.m_91298_().m_92577_(state, (BlockAndTintGetter)minecraft.f_91073_, pos, quad.m_111305_());
                                f = (float)(i >> 16 & 0xFF) / 255.0f;
                                f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                                f2 = (float)(i & 0xFF) / 255.0f;
                            } else {
                                f = 1.0f;
                                f1 = 1.0f;
                                f2 = 1.0f;
                            }
                            consumer.m_85987_(pose, quad, f, f1, f2, light, overlay);
                        }
                    }
                };
            }
        });
    }
}

