/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoofTopNew
extends Block {
    private static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCCLUSION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final EnumProperty<RoofPart> PART = EnumProperty.m_61587_((String)"part", RoofPart.class);

    public RoofTopNew(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)RoofPart.SWITCHED_0)));
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.m_46796_(1029, pos, 0);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter getter, BlockPos pos) {
        return OCCLUSION;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        return BASE;
    }

    private BlockState StairState(BlockState state, LevelAccessor access, BlockPos pos) {
        boolean north = access.m_8055_(pos.m_122012_()).m_60734_() == this;
        boolean east = access.m_8055_(pos.m_122029_()).m_60734_() == this;
        boolean south = access.m_8055_(pos.m_122019_()).m_60734_() == this;
        boolean west = access.m_8055_(pos.m_122024_()).m_60734_() == this;
        RoofPart connection = this.getConnectionStatus(north, east, south, west);
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)connection));
    }

    private RoofPart getConnectionStatus(boolean north, boolean east, boolean south, boolean west) {
        if (!north && !south && east && west) {
            return RoofPart.SWITCHED_90;
        }
        if (north && south && east && west) {
            return RoofPart.FOUR_WAY;
        }
        if (north && !south && !east && west) {
            return RoofPart.TOP_OUTER_0;
        }
        if (north && !south && east && !west) {
            return RoofPart.TOP_OUTER_90;
        }
        if (!north && south && east && !west) {
            return RoofPart.TOP_OUTER_180;
        }
        if (!north && south && !east && west) {
            return RoofPart.TOP_OUTER_270;
        }
        if (north && !south && !east && !west) {
            return RoofPart.TOP_END_0;
        }
        if (!north && !south && east && !west) {
            return RoofPart.TOP_END_90;
        }
        if (!north && south && !east && !west) {
            return RoofPart.TOP_END_180;
        }
        if (!north && !south && !east && west) {
            return RoofPart.TOP_END_270;
        }
        if (north && south && east && !west) {
            return RoofPart.THREE_WAY_0;
        }
        if (!north && south && east && west) {
            return RoofPart.THREE_WAY_90;
        }
        if (north && south && !east && west) {
            return RoofPart.THREE_WAY_180;
        }
        if (north && !south && east && west) {
            return RoofPart.THREE_WAY_270;
        }
        return RoofPart.SWITCHED_0;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return this.StairState(state, access, pos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext contx) {
        BlockPos pos = contx.m_8083_().m_7495_();
        Level world = contx.m_43725_();
        BlockState stateBelow = world.m_8055_(pos);
        if (stateBelow.m_60734_() instanceof RoofTopNew) {
            return null;
        }
        return this.StairState(super.m_5573_(contx), (LevelAccessor)world, contx.m_8083_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.m_60713_(state.m_60734_())) {
            level.m_7731_(pos, this.StairState(state, (LevelAccessor)level, pos), 2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            state = (BlockState)state.m_61122_(PART);
            world.m_7731_(pos, state, 1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART});
    }

    public void placeAt(Level world, BlockPos pos, int intos) {
        world.m_7731_(pos, this.m_49966_(), intos);
    }

    public static enum RoofPart implements StringRepresentable
    {
        PYRAMID("pyramid"),
        SWITCHED_0("switched_0"),
        SWITCHED_90("switched_90"),
        FOUR_WAY("four_way"),
        TOP_END_0("top_end_0"),
        TOP_END_90("top_end_90"),
        TOP_END_180("top_end_180"),
        TOP_END_270("top_end_270"),
        TOP_OUTER_0("top_outer_0"),
        TOP_OUTER_90("top_outer_90"),
        TOP_OUTER_180("top_outer_180"),
        TOP_OUTER_270("top_outer_270"),
        THREE_WAY_0("three_way_0"),
        THREE_WAY_90("three_way_90"),
        THREE_WAY_180("three_way_180"),
        THREE_WAY_270("three_way_270");

        private final String name;

        private RoofPart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

