/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.screens;

import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SoundUtil;
import forestry.worktable.recipes.RecipeMemory;
import forestry.worktable.screens.WorktableMenu;
import forestry.worktable.screens.widgets.ClearWorktable;
import forestry.worktable.screens.widgets.MemorizedRecipeSlot;
import forestry.worktable.tiles.WorktableTile;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class WorktableScreen
extends GuiForestryTitled<WorktableMenu> {
    private static final int SPACING = 18;
    private final WorktableTile worktable;
    private boolean hasRecipeConflict;

    public WorktableScreen(WorktableMenu container, Inventory inv, Component title) {
        super("textures/gui/worktable2.png", container, inv, title);
        this.worktable = (WorktableTile)container.getTile();
        this.f_97727_ = 218;
        RecipeMemory memory = this.worktable.getMemory();
        int slot = 0;
        for (int y = 0; y < 3; ++y) {
            int yPos = 20 + y * 18;
            for (int x = 0; x < 3; ++x) {
                int xPos = 110 + x * 18;
                this.widgetManager.add(new MemorizedRecipeSlot(this.widgetManager, xPos, yPos, memory, slot++));
            }
        }
        this.widgetManager.add(new ClearWorktable(this.widgetManager, 66, 19));
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        if (this.hasRecipeConflict != this.worktable.hasRecipeConflict()) {
            this.hasRecipeConflict = this.worktable.hasRecipeConflict();
            if (this.hasRecipeConflict) {
                this.addButtons();
            } else {
                this.f_169369_.clear();
            }
        }
    }

    private void addButtons() {
        this.m_142416_((GuiEventListener)new GuiBetterButton(this.f_97735_ + 76, this.f_97736_ + 56, StandardButtonTextureSets.LEFT_BUTTON_SMALL, b -> {
            NetworkUtil.sendToServer(new PacketGuiSelectRequest(100, 0));
            SoundUtil.playButtonClick();
        }));
        this.m_142416_((GuiEventListener)new GuiBetterButton(this.f_97735_ + 85, this.f_97736_ + 56, StandardButtonTextureSets.RIGHT_BUTTON_SMALL, b -> {
            NetworkUtil.sendToServer(new PacketGuiSelectRequest(101, 0));
            SoundUtil.playButtonClick();
        }));
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.worktable);
        this.addHintLedger("worktable");
    }
}

