/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.api.multiblock.IFarmComponent;
import forestry.farming.blocks.FarmBlock;
import forestry.farming.features.FarmingTiles;
import forestry.farming.tiles.TileFarm;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TileFarmControl
extends TileFarm
implements IFarmComponent.Listener {
    private final IFarmListener farmListener = new ControlFarmListener(this);

    public TileFarmControl(BlockPos pos, BlockState state) {
        super(FarmingTiles.CONTROL.tileType(), pos, state);
    }

    @Override
    public IFarmListener getFarmListener() {
        return this.farmListener;
    }

    private static class ControlFarmListener
    implements IFarmListener {
        private final TileFarmControl tile;

        public ControlFarmListener(TileFarmControl tile) {
            this.tile = tile;
        }

        @Override
        public boolean cancelTask(IFarmLogic logic, Direction direction) {
            for (Direction facing : new Direction[]{Direction.UP, Direction.DOWN, direction}) {
                BlockPos pos = this.tile.m_58899_();
                Level world = this.tile.getWorldObj();
                BlockState blockState = world.m_8055_(pos.m_121945_(facing));
                if (blockState.m_60734_() instanceof FarmBlock || world.m_277185_(pos, facing) <= 0) continue;
                return true;
            }
            return false;
        }
    }
}

