/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.blocks;

import forestry.core.blocks.BlockStructure;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.tiles.TileFarmControl;
import forestry.farming.tiles.TileFarmGearbox;
import forestry.farming.tiles.TileFarmHatch;
import forestry.farming.tiles.TileFarmPlain;
import forestry.farming.tiles.TileFarmValve;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FarmBlock
extends BlockStructure
implements EntityBlock {
    private final EnumFarmBlockType type;
    private final EnumFarmMaterial farmMaterial;
    public static final BooleanProperty BAND = BooleanProperty.m_61465_((String)"band");

    public FarmBlock(EnumFarmBlockType type, EnumFarmMaterial farmMaterial) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f));
        this.type = type;
        this.farmMaterial = farmMaterial;
    }

    public static FarmBlock create(EnumFarmBlockType type, EnumFarmMaterial material) {
        if (type == EnumFarmBlockType.PLAIN) {
            return new Plain(material);
        }
        return new FarmBlock(type, material);
    }

    public EnumFarmBlockType getType() {
        return this.type;
    }

    public EnumFarmMaterial getFarmMaterial() {
        return this.farmMaterial;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.type) {
            case EnumFarmBlockType.GEARBOX -> new TileFarmGearbox(pos, state);
            case EnumFarmBlockType.HATCH -> new TileFarmHatch(pos, state);
            case EnumFarmBlockType.VALVE -> new TileFarmValve(pos, state);
            case EnumFarmBlockType.CONTROL -> new TileFarmControl(pos, state);
            default -> new TileFarmPlain(pos, state);
        };
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction side) {
        return this.type == EnumFarmBlockType.CONTROL;
    }

    public static class Plain
    extends FarmBlock {
        public Plain(EnumFarmMaterial farmMaterial) {
            super(EnumFarmBlockType.PLAIN, farmMaterial);
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BAND, (Comparable)Boolean.valueOf(false)));
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{BAND});
        }
    }
}

