/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.ForestryError;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidRecipeFilter;
import forestry.core.fluids.TankManager;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.InventoryGhostCrafting;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.items.definitions.ICraftingPlan;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.RecipeUtils;
import forestry.factory.features.FactoryTiles;
import forestry.factory.gui.ContainerFabricator;
import forestry.factory.inventory.InventoryFabricator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileFabricator
extends TilePowered
implements ISlotPickupWatcher,
ILiquidTankTile,
WorldlyContainer {
    private static final int MAX_HEAT = 5000;
    private final InventoryAdapterTile craftingInventory;
    private final TankManager tankManager;
    private final FilteredTank moltenTank;
    private int heat = 0;
    private int meltingPoint = 0;

    public TileFabricator(BlockPos pos, BlockState state) {
        super(FactoryTiles.FABRICATOR.tileType(), pos, state, 1100, 3300);
        this.setEnergyPerWorkCycle(200);
        this.craftingInventory = new InventoryGhostCrafting<TileFabricator>(this, 9);
        this.setInternalInventory(new InventoryFabricator(this));
        this.moltenTank = new FilteredTank(8000, false, true).setFilter(FluidRecipeFilter.FABRICATOR_SMELTING_OUTPUT);
        this.tankManager = new TankManager(this, this.moltenTank);
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Heat", this.heat);
        this.tankManager.write(compound);
        this.craftingInventory.write(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.heat = compound.m_128451_("Heat");
        this.tankManager.read(compound);
        this.craftingInventory.read(compound);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        this.tankManager.writeData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(FriendlyByteBuf data) {
        this.tankManager.readData(data);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (!this.moltenTank.isFull()) {
            this.trySmelting();
        }
        if (!this.moltenTank.isEmpty() && this.heat < this.getMeltingPoint() - 100) {
            this.moltenTank.drain(5, IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    private void trySmelting() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack smeltResource = inventory.m_8020_(0);
        if (smeltResource.m_41619_()) {
            return;
        }
        IFabricatorSmeltingRecipe smelt = RecipeUtils.getFabricatorMeltingRecipe(this.f_58857_.m_7465_(), smeltResource);
        if (smelt == null || smelt.getMeltingPoint() > this.heat) {
            return;
        }
        FluidStack smeltFluid = smelt.getResultFluid();
        if (this.moltenTank.fillInternal(smeltFluid, IFluidHandler.FluidAction.SIMULATE) == smeltFluid.getAmount()) {
            this.m_7407_(0, 1);
            this.moltenTank.fillInternal(smeltFluid, IFluidHandler.FluidAction.EXECUTE);
            this.meltingPoint = smelt.getMeltingPoint();
        }
    }

    @Override
    public boolean workCycle() {
        this.heat += 100;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        this.craftResult();
        return true;
    }

    @Nullable
    private IFabricatorRecipe getRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack plan = inventory.m_8020_(1);
        FluidStack liquid = this.moltenTank.getFluid();
        IFabricatorRecipe recipe = RecipeUtils.getFabricatorRecipe(this.f_58857_.m_7465_(), this.f_58857_, liquid, plan, (Container)this.craftingInventory);
        if (!liquid.isEmpty() && recipe != null && !liquid.containsFluid(recipe.getResultFluid())) {
            return null;
        }
        return recipe;
    }

    public ItemStack getResult(@Nullable IFabricatorRecipe myRecipe) {
        if (myRecipe == null) {
            return ItemStack.f_41583_;
        }
        return myRecipe.getCraftingGridRecipe().m_8043_(this.f_58857_.m_9598_()).m_41777_();
    }

    @Override
    public void onTake(int slotIndex, Player player) {
        if (slotIndex == 2) {
            this.m_7407_(2, 1);
        }
    }

    private void craftResult() {
        IFabricatorRecipe myRecipe = this.getRecipe();
        ItemStack craftResult = this.getResult(myRecipe);
        if (myRecipe != null && !craftResult.m_41619_() && this.m_8020_(2).m_41619_()) {
            FluidStack drained;
            FluidStack liquid = myRecipe.getResultFluid();
            if (this.removeFromInventory(myRecipe, false) && !(drained = this.moltenTank.drainInternal(liquid, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && drained.isFluidStackIdentical(liquid)) {
                Item planItem;
                this.removeFromInventory(myRecipe, true);
                this.moltenTank.drain(liquid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                if (!this.m_8020_(1).m_41619_() && (planItem = this.m_8020_(1).m_41720_()) instanceof ICraftingPlan) {
                    ItemStack planUsed = ((ICraftingPlan)planItem).planUsed(this.m_8020_(1), craftResult);
                    this.m_6836_(1, planUsed);
                }
                this.m_6836_(2, craftResult);
            }
        }
    }

    private boolean removeFromInventory(IFabricatorRecipe recipe, boolean doRemove) {
        InventoryMapper inventory = new InventoryMapper((Container)this, 3, 18);
        return InventoryUtil.consumeIngredients(inventory, (List<Ingredient>)recipe.getCraftingGridRecipe().m_7527_(), null, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        boolean hasRecipe = true;
        boolean hasLiquidResources = true;
        boolean hasResources = true;
        ItemStack plan = this.m_8020_(1);
        IFabricatorRecipe recipe = RecipeUtils.getFabricatorRecipe(this.f_58857_.m_7465_(), this.f_58857_, this.moltenTank.getFluid(), plan, (Container)this.craftingInventory);
        if (recipe != null) {
            hasResources = this.removeFromInventory(recipe, false);
            FluidStack toDrain = recipe.getResultFluid();
            FluidStack drained = this.moltenTank.drainInternal(toDrain, IFluidHandler.FluidAction.SIMULATE);
            hasLiquidResources = !drained.isEmpty() && drained.isFluidStackIdentical(toDrain);
        } else {
            hasRecipe = RecipeUtils.getFabricatorMeltingRecipe(this.f_58857_.m_7465_(), this.m_8020_(0)) != null;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, ForestryError.NO_RECIPE);
        errorLogic.setCondition(!hasLiquidResources, ForestryError.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasResources, ForestryError.NO_RESOURCE_INVENTORY);
        return hasRecipe;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    private int getMeltingPoint() {
        if (!this.m_8020_(0).m_41619_()) {
            IFabricatorSmeltingRecipe meltingRecipe = RecipeUtils.getFabricatorMeltingRecipe(this.m_58904_().m_7465_(), this.m_8020_(0));
            return meltingRecipe == null ? 0 : meltingRecipe.getMeltingPoint();
        }
        if (this.moltenTank.getFluidAmount() > 0) {
            return this.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    public void getGUINetworkData(int i, int j) {
        if (i == 0) {
            this.heat = j;
        } else if (i == 1) {
            this.meltingPoint = j;
        }
    }

    public void sendGUINetworkData(AbstractContainerMenu container, ContainerListener iCrafting) {
        iCrafting.m_142153_(container, 0, this.heat);
        iCrafting.m_142153_(container, 1, this.getMeltingPoint());
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tankManager).cast();
        }
        return super.getCapability(capability, facing);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerFabricator(windowId, player.m_150109_(), this);
    }
}

