/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IStillRecipe;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class StillRecipe
implements IStillRecipe {
    private final ResourceLocation id;
    private final int timePerUnit;
    private final FluidStack input;
    private final FluidStack output;

    public StillRecipe(ResourceLocation id, int timePerUnit, FluidStack input, FluidStack output) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)input, (Object)"Still recipes need an input. Input was null.");
        Preconditions.checkNotNull((Object)output, (Object)"Still recipes need an output. Output was null.");
        this.id = id;
        this.timePerUnit = timePerUnit;
        this.input = input;
        this.output = output;
    }

    @Override
    public int getCyclesPerUnit() {
        return this.timePerUnit;
    }

    @Override
    public FluidStack getInput() {
        return this.input;
    }

    @Override
    public FluidStack getOutput() {
        return this.output;
    }

    @Override
    public boolean matches(FluidStack input) {
        return input.containsFluid(this.input);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.STILL.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.STILL.type();
    }

    public static class Serializer
    implements RecipeSerializer<StillRecipe> {
        public StillRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int timePerUnit = GsonHelper.m_13927_((JsonObject)json, (String)"time");
            FluidStack input = RecipeSerializers.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            FluidStack output = RecipeSerializers.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return new StillRecipe(recipeId, timePerUnit, input, output);
        }

        public StillRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int timePerUnit = buffer.m_130242_();
            FluidStack input = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            FluidStack output = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            return new StillRecipe(recipeId, timePerUnit, input, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, StillRecipe recipe) {
            buffer.m_130130_(recipe.timePerUnit);
            recipe.input.writeToPacket(buffer);
            recipe.output.writeToPacket(buffer);
        }
    }
}

