/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.api.modules.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileFabricator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketRecipeTransferUpdate(BlockPos pos, NonNullList<ItemStack> craftingInventory) implements IForestryPacketClient
{
    @Override
    public ResourceLocation id() {
        return PacketIdClient.RECIPE_TRANSFER_UPDATE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        NetworkUtil.writeItemStacks(buffer, this.craftingInventory);
    }

    public static PacketRecipeTransferUpdate decode(FriendlyByteBuf buffer) {
        return new PacketRecipeTransferUpdate(buffer.m_130135_(), NetworkUtil.readItemStacks(buffer));
    }

    public static void handle(PacketRecipeTransferUpdate msg, Player player) {
        block3: {
            BlockEntity tile;
            block2: {
                tile = TileUtil.getTile((BlockGetter)player.m_9236_(), msg.pos);
                if (!(tile instanceof TileCarpenter)) break block2;
                TileCarpenter carpenter = (TileCarpenter)tile;
                int index = 0;
                for (ItemStack stack : msg.craftingInventory) {
                    carpenter.getCraftingInventory().m_6836_(index, stack);
                    ++index;
                }
                break block3;
            }
            if (!(tile instanceof TileFabricator)) break block3;
            TileFabricator fabricator = (TileFabricator)tile;
            int index = 0;
            for (ItemStack stack : msg.craftingInventory) {
                fabricator.getCraftingInventory().m_6836_(index, stack);
                ++index;
            }
        }
    }
}

