/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.inventory;

import forestry.api.fuels.FuelManager;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.utils.RecipeUtils;
import forestry.core.utils.SlotUtil;
import forestry.factory.tiles.TileMoistener;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class InventoryMoistener
extends InventoryAdapterTile<TileMoistener> {
    public static final short SLOT_STASH_1 = 0;
    public static final short SLOT_STASH_COUNT = 6;
    public static final short SLOT_RESERVOIR_1 = 6;
    public static final short SLOT_RESERVOIR_COUNT = 3;
    public static final short SLOT_WORKING = 9;
    public static final short SLOT_PRODUCT = 10;
    public static final short SLOT_RESOURCE = 11;

    public InventoryMoistener(TileMoistener moistener) {
        super(moistener, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (slotIndex == 11) {
            return RecipeUtils.getMoistenerRecipe(((TileMoistener)this.tile).m_58904_().m_7465_(), stack) != null;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 0, 6)) {
            return FuelManager.moistenerResource.containsKey(stack);
        }
        if (slotIndex == 10) {
            Optional fluidCap = FluidUtil.getFluidContained((ItemStack)stack);
            return fluidCap.map(f -> ((TileMoistener)this.tile).getTankManager().canFillFluidType((FluidStack)f)).orElse(false);
        }
        return false;
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack itemstack, Direction side) {
        if (slotIndex == 10) {
            return true;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 0, 9)) {
            return !FuelManager.moistenerResource.containsKey(itemstack);
        }
        return false;
    }
}

