/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.ContainerLiquidTanks;
import forestry.core.gui.IContainerCrafting;
import forestry.core.gui.slots.SlotCraftMatrix;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.gui.slots.SlotLiquidIn;
import forestry.core.gui.slots.SlotLocked;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.network.packets.PacketItemStackDisplay;
import forestry.core.tiles.TileUtil;
import forestry.factory.features.FactoryMenuTypes;
import forestry.factory.tiles.TileCarpenter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;

public class ContainerCarpenter
extends ContainerLiquidTanks<TileCarpenter>
implements IContainerCrafting {
    private ItemStack oldCraftPreview = ItemStack.f_41583_;

    public static ContainerCarpenter fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        TileCarpenter tile = TileUtil.getTile((BlockGetter)inv.f_35978_.m_9236_(), data.m_130135_(), TileCarpenter.class);
        return new ContainerCarpenter(windowId, inv, tile);
    }

    public ContainerCarpenter(int windowId, Inventory inventoryplayer, TileCarpenter tile) {
        super(windowId, FactoryMenuTypes.CARPENTER.menuType(), inventoryplayer, tile, 8, 136);
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)tile, 12 + k + i * 9, 8 + k * 18, 90 + i * 18));
            }
        }
        this.m_38897_(new SlotLiquidIn(tile, 11, 120, 20));
        this.m_38897_(new SlotFiltered(tile, 9, 83, 20));
        this.m_38897_(new SlotOutput((Container)tile, 10, 120, 56));
        this.m_38897_(new SlotLocked(tile.getCraftPreviewInventory(), 0, 80, 51));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.m_38897_(new SlotCraftMatrix(this, tile.getCraftingInventory(), k1 + l * 3, 10 + k1 * 18, 20 + l * 18));
            }
        }
    }

    @Override
    public void onCraftMatrixChanged(Container iinventory, int slot) {
        ((TileCarpenter)this.tile).checkRecipe(((TileCarpenter)this.tile).m_58904_().m_9598_());
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        Container craftPreviewInventory = ((TileCarpenter)this.tile).getCraftPreviewInventory();
        ItemStack newCraftPreview = craftPreviewInventory.m_8020_(0);
        if (!ItemStack.m_41728_((ItemStack)this.oldCraftPreview, (ItemStack)newCraftPreview)) {
            this.oldCraftPreview = newCraftPreview;
            PacketItemStackDisplay packet = new PacketItemStackDisplay((TileCarpenter)this.tile, newCraftPreview);
            this.sendPacketToListeners(packet);
        }
    }

    public TileCarpenter getCarpenter() {
        return (TileCarpenter)this.tile;
    }
}

