/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.blocks;

import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IMachineProperties;
import forestry.core.blocks.MachineProperties;
import forestry.energy.features.EnergyTiles;
import forestry.energy.tiles.EngineBlockEntity;
import forestry.modules.features.FeatureTileType;

public enum EngineBlockType implements IBlockType
{
    PEAT(EngineBlockType.createEngineProperties(EnergyTiles.PEAT_ENGINE, "peat")),
    BIOGAS(EngineBlockType.createEngineProperties(EnergyTiles.BIOGAS_ENGINE, "biogas")),
    CLOCKWORK(EngineBlockType.createEngineProperties(EnergyTiles.CLOCKWORK_ENGINE, "clockwork"));

    public static final EngineBlockType[] VALUES;
    private final IMachineProperties<?> machineProperties;

    private EngineBlockType(IMachineProperties<?> machineProperties) {
        this.machineProperties = machineProperties;
    }

    private static <T extends EngineBlockEntity> IMachineProperties<T> createEngineProperties(FeatureTileType<T> teClass, String name) {
        return ((MachineProperties.Builder)((MachineProperties.Builder)new MachineProperties.Builder(teClass, name).setClientTicker(EngineBlockEntity::clientTick)).setServerTicker(EngineBlockEntity::serverTick)).create();
    }

    @Override
    public IMachineProperties<?> getMachineProperties() {
        return this.machineProperties;
    }

    public String m_7912_() {
        return this.getMachineProperties().m_7912_();
    }

    static {
        VALUES = EngineBlockType.values();
    }
}

