/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import forestry.api.ForestryConstants;
import forestry.core.worldgen.ApiaristPoolElement;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class VillagerJigsaw {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    public static void init(Registry<StructureTemplatePool> pools, Registry<StructureProcessorList> processors) {
        VillagerJigsaw.addVillagerHouse(pools, processors, "plains", 15);
        VillagerJigsaw.addVillagerHouse(pools, processors, "snowy", 15);
        VillagerJigsaw.addVillagerHouse(pools, processors, "savanna", 15);
        VillagerJigsaw.addVillagerHouse(pools, processors, "desert", 15);
        VillagerJigsaw.addVillagerHouse(pools, processors, "taiga", 15);
    }

    private static void addVillagerHouse(Registry<StructureTemplatePool> pools, Registry<StructureProcessorList> processors, String biome, int weight) {
        VillagerJigsaw.addToJigsawPattern(pools, new ResourceLocation("village/" + biome + "/houses"), (StructurePoolElement)new ApiaristPoolElement((Either<ResourceLocation, StructureTemplate>)Either.left((Object)ForestryConstants.forestry("village/apiarist_house_" + biome + "_1")), (Holder<StructureProcessorList>)processors.m_246971_(EMPTY_PROCESSOR_LIST_KEY)), weight);
    }

    public static void addToJigsawPattern(Registry<StructureTemplatePool> pools, ResourceLocation pool, StructurePoolElement newPiece, int weight) {
        StructureTemplatePool oldPool = (StructureTemplatePool)pools.m_7745_(pool);
        if (oldPool != null) {
            ObjectArrayList jigsawPieces = oldPool.f_210560_;
            for (int i = 0; i < weight; ++i) {
                jigsawPieces.add(newPiece);
            }
            ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(oldPool.f_210559_);
            listOfPieceEntries.add(new Pair((Object)newPiece, (Object)weight));
            oldPool.f_210559_ = listOfPieceEntries;
        }
    }
}

