/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StringUtil {
    private static final Pattern camelCaseToUnderscores = Pattern.compile("(.)([A-Z])");

    public static String camelCaseToUnderscores(String uid) {
        return camelCaseToUnderscores.matcher(uid).replaceAll("$1_$2").toLowerCase(Locale.ENGLISH);
    }

    public static String append(String delim, String source, String appendix) {
        if (source.length() <= 0) {
            return appendix;
        }
        if (appendix.length() <= 0) {
            return source;
        }
        return source + delim + appendix;
    }

    public static String floatAsPercent(float val) {
        return (int)(val * 100.0f) + " %";
    }

    public static Component line(int length) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            line.append('-');
        }
        return Component.m_237113_((String)line.toString());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getLineHeight(int maxWidth, FormattedText ... strings) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        int lineCount = 0;
        for (FormattedText string : strings) {
            lineCount += fontRenderer.m_92923_(string, maxWidth).size();
        }
        Objects.requireNonNull(fontRenderer);
        return lineCount * 9;
    }
}

