/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.gui.slots.SlotForestry;
import forestry.core.gui.slots.WorktableSlot;
import forestry.core.utils.ItemStackUtil;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class SlotUtil {
    private static final int PLAYER_INVENTORY_SIZE = 36;
    private static final int PLAYER_HOTBAR_SIZE = 9;

    public static boolean isSlotInRange(int slotIndex, int start, int count) {
        return slotIndex >= start && slotIndex < start + count;
    }

    public static ItemStack slotClickPhantom(SlotForestry slot, int mouseButton, ClickType clickTypeIn, Player player) {
        ItemStack stack = ItemStack.f_41583_;
        ItemStack stackSlot = slot.m_7993_();
        if (!stackSlot.m_41619_()) {
            stack = stackSlot.m_41777_();
        }
        if (mouseButton == 2) {
            SlotUtil.fillPhantomSlot(slot, ItemStack.f_41583_, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {
            ItemStack stackHeld = player.f_36096_.m_142621_();
            if (stackSlot.m_41619_()) {
                if (!stackHeld.m_41619_() && slot.m_5857_(stackHeld)) {
                    SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld.m_41619_()) {
                SlotUtil.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
            } else if (slot.m_5857_(stackHeld)) {
                if (ItemStackUtil.isIdenticalItem(stackSlot, stackHeld)) {
                    SlotUtil.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
                } else {
                    SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            }
        } else if (mouseButton == 5) {
            ItemStack stackHeld = player.f_36096_.m_142621_();
            if (!slot.m_6657_()) {
                SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        }
        return stack;
    }

    public static ItemStack transferStackInSlot(List<Slot> inventorySlots, Player player, int slotIndex) {
        Slot slot = inventorySlots.get(slotIndex);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        boolean fromCraftingSlot = slot instanceof ResultSlot || slot instanceof WorktableSlot;
        int numSlots = inventorySlots.size();
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack originalStack = stackInSlot.m_41777_();
        if (!SlotUtil.shiftItemStack(inventorySlots, stackInSlot, slotIndex, numSlots, fromCraftingSlot)) {
            return ItemStack.f_41583_;
        }
        slot.m_40234_(stackInSlot, originalStack);
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stackInSlot.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        return originalStack;
    }

    private static boolean shiftItemStack(List<Slot> inventorySlots, ItemStack stackInSlot, int slotIndex, int numSlots, boolean fromCraftingSlot) {
        if (SlotUtil.isInPlayerInventory(slotIndex)) {
            if (SlotUtil.shiftToMachineInventory(inventorySlots, stackInSlot, numSlots)) {
                return true;
            }
            if (SlotUtil.isInPlayerHotbar(slotIndex)) {
                return SlotUtil.shiftToPlayerInventoryNoHotbar(inventorySlots, stackInSlot);
            }
            return SlotUtil.shiftToHotbar(inventorySlots, stackInSlot);
        }
        if (fromCraftingSlot && SlotUtil.shiftToMachineInventory(inventorySlots, stackInSlot, numSlots)) {
            return true;
        }
        return SlotUtil.shiftToPlayerInventory(inventorySlots, stackInSlot);
    }

    private static void adjustPhantomSlot(SlotForestry slot, int mouseButton, ClickType clickTypeIn) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.m_7993_();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.m_41613_() + 1) / 2 : stackSlot.m_41613_() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.m_41613_() - 1 : stackSlot.m_41613_() + 1;
        }
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        stackSlot.m_41764_(stackSize);
        slot.m_5852_(stackSlot);
    }

    private static void fillPhantomSlot(SlotForestry slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        if (stackHeld.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.m_41613_() : 1;
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        ItemStack phantomStack = stackHeld.m_41777_();
        phantomStack.m_41764_(stackSize);
        slot.m_5852_(phantomStack);
    }

    private static boolean shiftItemStackToRange(List<Slot> inventorySlots, ItemStack stackToShift, int start, int count) {
        boolean changed = SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackToShift, start, count);
        return changed |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackToShift, start, count);
    }

    private static boolean shiftItemStackToRangeMerge(List<Slot> inventorySlots, ItemStack stackToShift, int start, int count) {
        if (!stackToShift.m_41753_() || stackToShift.m_41619_()) {
            return false;
        }
        boolean changed = false;
        for (int slotIndex = start; !stackToShift.m_41619_() && slotIndex < start + count; ++slotIndex) {
            int max;
            Slot slot = inventorySlots.get(slotIndex);
            ItemStack stackInSlot = slot.m_7993_();
            if (stackInSlot.m_41619_() || !ItemStackUtil.isIdenticalItem(stackInSlot, stackToShift)) continue;
            int resultingStackSize = stackInSlot.m_41613_() + stackToShift.m_41613_();
            if (resultingStackSize <= (max = Math.min(stackToShift.m_41741_(), slot.m_6641_()))) {
                stackToShift.m_41764_(0);
                stackInSlot.m_41764_(resultingStackSize);
                slot.m_6654_();
                changed = true;
                continue;
            }
            if (stackInSlot.m_41613_() >= max) continue;
            stackToShift.m_41774_(max - stackInSlot.m_41613_());
            stackInSlot.m_41764_(max);
            slot.m_6654_();
            changed = true;
        }
        return changed;
    }

    private static boolean shiftItemStackToRangeOpenSlots(List<Slot> inventorySlots, ItemStack stackToShift, int start, int count) {
        if (stackToShift.m_41619_()) {
            return false;
        }
        boolean changed = false;
        for (int slotIndex = start; !stackToShift.m_41619_() && slotIndex < start + count; ++slotIndex) {
            Slot slot = inventorySlots.get(slotIndex);
            ItemStack stackInSlot = slot.m_7993_();
            if (!stackInSlot.m_41619_()) continue;
            int max = Math.min(stackToShift.m_41741_(), slot.m_6641_());
            stackInSlot = stackToShift.m_41777_();
            stackInSlot.m_41764_(Math.min(stackToShift.m_41613_(), max));
            stackToShift.m_41774_(stackInSlot.m_41613_());
            slot.m_5852_(stackInSlot);
            slot.m_6654_();
            changed = true;
        }
        return changed;
    }

    private static boolean isInPlayerInventory(int slotIndex) {
        return slotIndex < 36;
    }

    private static boolean isInPlayerHotbar(int slotIndex) {
        return SlotUtil.isSlotInRange(slotIndex, 27, 36);
    }

    private static boolean shiftToPlayerInventory(List<Slot> inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        boolean shifted = SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackInSlot, playerHotbarStart, 9);
        shifted |= SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackInSlot, 0, playerHotbarStart);
        shifted |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackInSlot, playerHotbarStart, 9);
        return shifted |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackInSlot, 0, playerHotbarStart);
    }

    private static boolean shiftToPlayerInventoryNoHotbar(List<Slot> inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotUtil.shiftItemStackToRange(inventorySlots, stackInSlot, 0, playerHotbarStart);
    }

    private static boolean shiftToHotbar(List<Slot> inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotUtil.shiftItemStackToRange(inventorySlots, stackInSlot, playerHotbarStart, 9);
    }

    private static boolean shiftToMachineInventory(List<Slot> inventorySlots, ItemStack stackToShift, int numSlots) {
        boolean success = false;
        if (stackToShift.m_41753_()) {
            success = SlotUtil.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, true);
        }
        if (!stackToShift.m_41619_()) {
            success |= SlotUtil.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, false);
        }
        return success;
    }

    private static boolean shiftToMachineInventory(List<Slot> inventorySlots, ItemStack stackToShift, int numSlots, boolean mergeOnly) {
        for (int machineIndex = 36; machineIndex < numSlots; ++machineIndex) {
            SlotForestry slotForestry;
            Slot slot = inventorySlots.get(machineIndex);
            if (mergeOnly && slot.m_7993_().m_41619_() || slot instanceof SlotForestry && (!(slotForestry = (SlotForestry)slot).canShift() || slotForestry.isPhantom()) || !slot.m_5857_(stackToShift) || !SlotUtil.shiftItemStackToRange(inventorySlots, stackToShift, machineIndex, 1)) continue;
            return true;
        }
        return false;
    }
}

