/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import forestry.Forestry;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.JsonUtils;

public class JsonUtil {
    public static ItemStack deserializeItemStack(JsonObject object, ItemStack fallback) {
        return JsonUtil.deserializeItemStack(object, fallback, false);
    }

    public static ItemStack deserializeItemStack(JsonObject object, ItemStack fallback, boolean logError) {
        if (!object.has("item")) {
            if (logError) {
                Forestry.LOGGER.error("Unsupported icon type, currently only items are supported (add 'item' key)");
            }
            return fallback;
        }
        try {
            Item item = GsonHelper.m_13909_((JsonObject)object, (String)"item");
            int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
            ItemStack stack = new ItemStack((ItemLike)item, count);
            stack.m_41751_(JsonUtils.readNBT((JsonObject)object, (String)"nbt"));
            return stack;
        }
        catch (JsonSyntaxException e) {
            if (logError) {
                Forestry.LOGGER.trace("Filed to parse item.", (Throwable)e);
            }
            return fallback;
        }
    }

    public static <T> T deserialize(Codec<T> codec, JsonElement json) {
        return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().get()).getFirst();
    }

    public static <T> JsonElement serialize(Codec<T> codec, T object) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).result().get();
    }
}

