/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.ForestryCapabilities;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.core.IArmorNaturalist;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.arboriculture.capabilities.ArmorNaturalist;
import forestry.core.genetics.ItemGE;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public class GeneticsUtil {
    private static String getKeyPrefix(ISpecies<?> allele) {
        if (allele instanceof IBeeSpecies) {
            return "for.bees";
        }
        if (allele instanceof ITreeSpecies) {
            return "for.trees";
        }
        if (allele instanceof IButterflySpecies) {
            return "for.butterflies";
        }
        throw new IllegalStateException();
    }

    public static Component getAlyzerName(ILifeStage type, ISpecies<?> allele) {
        String customKey = GeneticsUtil.getKeyPrefix(allele) + ".custom.alyzer." + type.m_7912_() + "." + allele.getTranslationKey();
        return Translator.tryTranslate(customKey, allele::getDisplayName);
    }

    public static Component getItemName(ILifeStage type, ISpecies<?> species) {
        String prefix = GeneticsUtil.getKeyPrefix(species);
        String customKey = prefix + ".custom." + type.m_7912_() + "." + species.getTranslationKey();
        return Translator.tryTranslate(customKey, () -> {
            MutableComponent speciesName = species.getDisplayName();
            MutableComponent typeName = Component.m_237115_((String)(prefix + ".grammar." + type.m_7912_() + ".type"));
            return Component.m_237110_((String)(prefix + ".grammar." + type.m_7912_()), (Object[])new Object[]{speciesName, typeName});
        });
    }

    public static boolean hasNaturalistEye(Player player) {
        ItemStack armorItemStack = player.m_6844_(EquipmentSlot.HEAD);
        if (armorItemStack.m_41619_()) {
            return false;
        }
        LazyOptional armorCap = armorItemStack.getCapability(ForestryCapabilities.ARMOR_NATURALIST);
        if (!armorCap.isPresent()) {
            return false;
        }
        IArmorNaturalist armorNaturalist = (IArmorNaturalist)armorCap.orElse((Object)ArmorNaturalist.INSTANCE);
        return armorNaturalist.canSeePollination(player, armorItemStack, true);
    }

    public static boolean canNurse(IButterfly butterfly, Level world, BlockPos pos) {
        IButterflyNursery tile = TileUtil.getTile((BlockGetter)world, pos, IButterflyNursery.class);
        return tile != null && tile.canNurse(butterfly);
    }

    public static ItemStack convertToGeneticEquivalent(ItemStack foreign) {
        IIndividualHandlerItem individual = IIndividualHandlerItem.get(foreign);
        if (individual != null && !individual.isGeneticForm()) {
            ItemStack equivalent = individual.getIndividual().getSpecies().createStack(individual.getStage());
            equivalent.m_41764_(foreign.m_41613_());
            return equivalent;
        }
        return foreign;
    }

    public static int getResearchComplexity(ISpecies<?> species) {
        return 1 + GeneticsUtil.getGeneticAdvancement(species, new HashSet());
    }

    private static int getGeneticAdvancement(ISpecies<?> species, Set<ISpecies<?>> exclude) {
        int highest = 0;
        exclude.add(species);
        ISpeciesType<ISpecies<?>, ?> type = species.getType();
        for (IMutation<ISpecies<?>> mutation : type.getMutations().getMutationsInto(species)) {
            highest = GeneticsUtil.getHighestAdvancement(mutation.getFirstParent(), highest, exclude);
            highest = GeneticsUtil.getHighestAdvancement(mutation.getSecondParent(), highest, exclude);
        }
        return 1 + highest;
    }

    private static int getHighestAdvancement(ISpecies<?> mutationSpecies, int highest, Set<ISpecies<?>> exclude) {
        if (exclude.contains(mutationSpecies)) {
            return highest;
        }
        int otherAdvance = GeneticsUtil.getGeneticAdvancement(mutationSpecies, exclude);
        return Math.max(otherAdvance, highest);
    }

    public static String createTranslationKey(String type, ResourceLocation typeId, ResourceLocation objectId) {
        String typeNamespace = typeId.m_135827_();
        StringBuilder translationKey = new StringBuilder(type);
        if (!type.isEmpty()) {
            translationKey.append('.');
        }
        translationKey.append(typeNamespace);
        translationKey.append('.');
        translationKey.append(typeId.m_135815_());
        translationKey.append('.');
        String speciesNamespace = objectId.m_135827_();
        if (speciesNamespace.equals(typeNamespace)) {
            translationKey.append(objectId.m_135815_());
        } else {
            translationKey.append(speciesNamespace);
            translationKey.append('.');
            translationKey.append(objectId.m_135815_());
        }
        return translationKey.toString();
    }

    public static IdentityHashMap<ISpecies<?>, ItemStack> getIconStacks(ILifeStage stage, ISpeciesType<?, ?> type) {
        IdentityHashMap map = new IdentityHashMap();
        GeneticsUtil.getIconStacks(map, stage, type);
        return map;
    }

    public static void getIconStacks(Map<ISpecies<?>, ItemStack> map, ILifeStage stage, ISpeciesType<?, ?> type) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(type.getAllSpecies().size());
        ItemGE.addCreativeItems(stage, itemList, false, type);
        for (ItemStack stack : itemList) {
            IIndividualHandlerItem.ifPresent(stack, individual -> {
                ISpecies<?> species = individual.getSpecies();
                map.put(species, stack);
            });
        }
    }
}

