/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

public class ColourUtil {
    private ColourUtil() {
    }

    public static int addRGBComponents(int colour, int r, int g, int b) {
        r = ColourUtil.getRed(colour) + r;
        g = ColourUtil.getGreen(colour) + g;
        b = ColourUtil.getBlue(colour) + b;
        r = Math.min(r, 255);
        g = Math.min(g, 255);
        b = Math.min(b, 255);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int multiplyRGBComponents(int colour, float factor) {
        int r = (int)((float)ColourUtil.getRed(colour) * factor);
        int g = (int)((float)ColourUtil.getGreen(colour) * factor);
        int b = (int)((float)ColourUtil.getBlue(colour) * factor);
        r = Math.min(r, 255);
        g = Math.min(g, 255);
        b = Math.min(b, 255);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getRed(int colour) {
        return (colour & 0xFF0000) >> 16;
    }

    public static int getGreen(int colour) {
        return (colour & 0xFF00) >> 8;
    }

    public static int getBlue(int colour) {
        return colour & 0xFF;
    }

    public static float getRedAsFloat(int colour) {
        return (float)ColourUtil.getRed(colour) / 255.0f;
    }

    public static float getGreenAsFloat(int colour) {
        return (float)ColourUtil.getGreen(colour) / 255.0f;
    }

    public static float getBlueAsFloat(int colour) {
        return (float)ColourUtil.getBlue(colour) / 255.0f;
    }
}

