/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.tiles.TileUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public abstract class BlockUtil {
    public static final BlockBehaviour.StatePredicate ALWAYS = (state, level, pos) -> true;
    public static final BlockBehaviour.StatePredicate NEVER = (state, level, pos) -> false;
    public static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> NEVER_SPAWN = (a, b, c, entityType) -> false;
    public static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> IS_PARROT_OR_OCELOT = (a, b, c, entityType) -> entityType == EntityType.f_20505_ || entityType == EntityType.f_20508_;

    public static List<ItemStack> getBlockDrops(LevelAccessor level, BlockPos pos) {
        return Block.m_49869_((BlockState)level.m_8055_(pos), (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)TileUtil.getTile((BlockGetter)level, pos));
    }

    public static boolean tryPlantCocoaPod(LevelAccessor world, BlockPos pos) {
        Direction facing = BlockUtil.getValidPodFacing(world, pos, (TagKey<Block>)BlockTags.f_13111_);
        if (facing == null) {
            return false;
        }
        BlockState state = (BlockState)Blocks.f_50262_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing);
        world.m_7731_(pos, state, 18);
        return true;
    }

    @Nullable
    public static Direction getValidPodFacing(LevelAccessor world, BlockPos pos, TagKey<Block> logTag) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (!BlockUtil.isValidPodLocation((LevelReader)world, pos, facing, logTag)) continue;
            return facing;
        }
        return null;
    }

    public static boolean isValidPodLocation(LevelReader world, BlockPos pos, Direction direction, TagKey<Block> logTag) {
        if (!world.m_46805_(pos = pos.m_121945_(direction))) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        return state.m_204336_(logTag);
    }

    public static boolean isBreakableBlock(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return BlockUtil.isBreakableBlock(blockState, world, pos);
    }

    public static boolean isBreakableBlock(BlockState blockState, Level world, BlockPos pos) {
        return blockState.m_60800_((BlockGetter)world, pos) >= 0.0f;
    }

    public static boolean isReplaceableBlock(BlockState blockState, Level world, BlockPos pos) {
        Block block = blockState.m_60734_();
        return world.m_8055_(pos).m_247087_();
    }

    public static boolean canReplace(BlockState blockState, LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos).m_247087_() && !blockState.m_278721_();
    }

    public static boolean canPlaceTree(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockPos downPos = pos.m_7495_();
        BlockState belowState = world.m_8055_(downPos);
        return (!world.m_8055_(pos).m_247087_() || !state.m_278721_()) && !belowState.m_204336_(BlockTags.f_13035_) && !belowState.m_204336_(BlockTags.f_13106_);
    }

    public static BlockPos getNextReplaceableUpPos(Level world, BlockPos pos) {
        BlockPos topPos = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos);
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos();
        BlockState blockState = world.m_8055_((BlockPos)newPos.m_122190_((Vec3i)pos));
        while (!BlockUtil.canReplace(blockState, (LevelAccessor)world, (BlockPos)newPos)) {
            newPos.m_122173_(Direction.UP);
            if (newPos.m_123342_() > topPos.m_123342_()) {
                return null;
            }
            blockState = world.m_8055_((BlockPos)newPos);
        }
        return newPos.m_7495_();
    }

    @Nullable
    public static BlockPos getNextSolidDownPos(Level world, BlockPos pos) {
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos();
        BlockState blockState = world.m_8055_((BlockPos)newPos.m_122190_((Vec3i)pos));
        while (BlockUtil.canReplace(blockState, (LevelAccessor)world, (BlockPos)newPos)) {
            newPos.m_122173_(Direction.DOWN);
            if (newPos.m_123342_() <= 0) {
                return null;
            }
            blockState = world.m_8055_((BlockPos)newPos);
        }
        return newPos.m_7494_();
    }

    public static boolean setBlockWithPlaceSound(Level level, BlockPos pos, BlockState state) {
        if (level.m_46597_(pos, state)) {
            BlockUtil.sendPlaceSound(level, pos, state);
            return true;
        }
        return false;
    }

    public static void setBlockWithBreakSound(Level level, BlockPos pos, BlockState blockState, BlockState oldState) {
        if (level.m_46597_(pos, blockState)) {
            BlockUtil.sendDestroyEffects(level, pos, oldState);
        }
    }

    public static void setBlockToAirWithSound(Level level, BlockPos pos, BlockState oldState) {
        if (level.m_7471_(pos, false)) {
            BlockUtil.sendDestroyEffects(level, pos, oldState);
        }
    }

    public static void sendDestroyEffects(Level level, BlockPos pos, BlockState state) {
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
    }

    public static void sendPlaceSound(Level level, BlockPos pos, BlockState state) {
        SoundType soundType = state.m_60827_();
        level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.f_56731_ + 1.0f) / 2.0f, soundType.f_56732_ * 0.8f);
    }

    public static BlockPos getPos(LootParams.Builder context) {
        Vec3 origin = (Vec3)context.m_287159_(LootContextParams.f_81460_);
        return origin != null ? BlockPos.m_274446_((Position)origin) : BlockPos.f_121853_;
    }
}

