/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.network.IStreamable;
import forestry.core.tiles.EscritoireGameBoard;
import forestry.core.tiles.EscritoireGameToken;
import forestry.core.utils.NetworkUtil;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class EscritoireGame
implements INbtWritable,
INbtReadable,
IStreamable {
    private static final RandomSource rand = RandomSource.m_216327_();
    public static final int BOUNTY_MAX = 16;
    private EscritoireGameBoard gameBoard;
    private long lastUpdate;
    private int bountyLevel;
    private Status status = Status.EMPTY;

    public EscritoireGame() {
        this.gameBoard = new EscritoireGameBoard();
    }

    @Nullable
    public EscritoireGameToken getToken(int index) {
        return this.gameBoard.getToken(index);
    }

    public Status getStatus() {
        return this.status;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public CompoundTag write(CompoundTag compoundNBT) {
        compoundNBT.m_128405_("bountyLevel", this.bountyLevel);
        compoundNBT.m_128356_("lastUpdate", this.lastUpdate);
        this.gameBoard.write(compoundNBT);
        compoundNBT.m_128405_("Status", this.status.ordinal());
        return compoundNBT;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.bountyLevel = nbt.m_128451_("bountyLevel");
        this.lastUpdate = nbt.m_128454_("lastUpdate");
        this.gameBoard = new EscritoireGameBoard(nbt);
        if (nbt.m_128441_("Status")) {
            int statusOrdinal = nbt.m_128451_("Status");
            this.status = Status.values()[statusOrdinal];
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        data.writeInt(this.bountyLevel);
        this.gameBoard.writeData(data);
        NetworkUtil.writeEnum(data, this.status);
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        this.bountyLevel = data.readInt();
        this.gameBoard.readData(data);
        this.status = (Status)NetworkUtil.readEnum((FriendlyByteBuf)data, (Enum[])Status.VALUES);
    }

    public void initialize(ItemStack specimen) {
        this.reset();
        if (this.gameBoard.initialize(specimen)) {
            this.status = Status.PLAYING;
            this.bountyLevel = 16;
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    public void probe(ItemStack specimen, Container inventory, int startSlot, int slotCount) {
        if (this.status != Status.PLAYING) {
            return;
        }
        IIndividualHandlerItem.ifPresent(specimen, individual -> {
            if (this.bountyLevel > 1) {
                --this.bountyLevel;
            }
            ISpecies<?> species = individual.getSpecies();
            ISpeciesType<ISpecies<?>, ?> type = species.getType();
            this.gameBoard.hideProbedTokens();
            int revealCount = this.getSampleSize(slotCount);
            for (int i = 0; i < revealCount; ++i) {
                ItemStack sample = inventory.m_7407_(startSlot + i, 1);
                if (sample.m_41619_() || !(rand.m_188501_() < type.getResearchSuitability(species, sample))) continue;
                this.gameBoard.probe();
            }
            this.lastUpdate = System.currentTimeMillis();
        });
    }

    public void reset() {
        this.bountyLevel = 16;
        this.gameBoard.reset();
        this.status = Status.EMPTY;
        this.lastUpdate = System.currentTimeMillis();
    }

    public void choose(int tokenIndex) {
        if (this.status != Status.PLAYING) {
            return;
        }
        EscritoireGameToken token = this.gameBoard.getToken(tokenIndex);
        if (token != null) {
            this.status = this.gameBoard.choose(token);
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    public int getBountyLevel() {
        return this.bountyLevel;
    }

    public int getSampleSize(int slotCount) {
        if (this.status == Status.EMPTY) {
            return 0;
        }
        int samples = this.gameBoard.getTokenCount() / 4;
        samples = Math.max(samples, 2);
        return Math.min(samples, slotCount);
    }

    public static enum Status {
        EMPTY,
        PLAYING,
        FAILURE,
        SUCCESS;

        public static final Status[] VALUES;

        static {
            VALUES = Status.values();
        }
    }
}

