/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.patchouli.processor;

import com.google.common.base.Preconditions;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.core.utils.ModUtil;
import forestry.core.utils.RecipeUtils;
import forestry.factory.features.FactoryRecipeTypes;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class FabricatorProcessor
implements IComponentProcessor {
    @Nullable
    protected IFabricatorRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        ItemStack stack = (ItemStack)variables.get("item").as(ItemStack.class, (Object)ItemStack.f_41583_);
        this.recipe = RecipeUtils.getRecipeByOutput(FactoryRecipeTypes.FABRICATOR, level.m_9598_(), stack);
    }

    public IVariable process(Level level, String key) {
        Preconditions.checkNotNull((Object)this.recipe);
        if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.getCraftingGridRecipe().m_8043_(level.m_9598_()));
        }
        if (key.equals("fluid")) {
            return IVariable.wrap((String)ModUtil.getRegistryName(this.recipe.getResultFluid().getFluid()).toString());
        }
        if (key.equals("fluidAmount")) {
            return IVariable.wrap((Number)this.recipe.getResultFluid().getAmount());
        }
        if (key.startsWith("ingredient")) {
            Ingredient ingredient;
            int index = Integer.parseInt(key.substring("ingredient".length()));
            if (index < 1 || index > 9) {
                return IVariable.empty();
            }
            try {
                ingredient = (Ingredient)this.recipe.getCraftingGridRecipe().m_7527_().get(index - 1);
            }
            catch (Exception e) {
                ingredient = Ingredient.f_43901_;
            }
            return IVariable.from((Object)ingredient.m_43908_());
        }
        if (key.equals("plan")) {
            return IVariable.from((Object)this.recipe.getPlan());
        }
        if (key.equals("metal")) {
            if (ModUtil.getRegistryName(this.recipe.getResultFluid().getFluid()).m_135815_().contains("glass")) {
                return IVariable.from((Object)new ItemStack((ItemLike)Items.f_41830_));
            }
            return RecipeUtils.getRecipes(RecipeUtils.getRecipeManager(), FactoryRecipeTypes.FABRICATOR_SMELTING).filter(recipe -> recipe.getResultFluid().isFluidEqual(this.recipe.getResultFluid())).flatMap(r -> Arrays.stream(r.getInput().m_43908_())).findFirst().map(IVariable::from).orElseGet(IVariable::empty);
        }
        return IVariable.empty();
    }
}

