/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.owner;

import com.mojang.authlib.GameProfile;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.owner.IOwnerHandler;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class OwnerHandler
implements IOwnerHandler,
IStreamable,
INbtWritable,
INbtReadable {
    @Nullable
    private GameProfile owner = null;

    @Override
    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        if (this.owner == null) {
            data.writeBoolean(false);
        } else {
            data.writeBoolean(true);
            data.writeLong(this.owner.getId().getMostSignificantBits());
            data.writeLong(this.owner.getId().getLeastSignificantBits());
            data.m_130070_(this.owner.getName());
        }
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        if (data.readBoolean()) {
            GameProfile owner = new GameProfile(new UUID(data.readLong(), data.readLong()), data.m_130277_());
            this.setOwner(owner);
        }
    }

    @Override
    public void read(CompoundTag data) {
        GameProfile owner;
        if (data.m_128441_("owner") && (owner = NbtUtils.m_129228_((CompoundTag)data.m_128469_("owner"))) != null) {
            this.setOwner(owner);
        }
    }

    @Override
    public CompoundTag write(CompoundTag data) {
        if (this.owner != null) {
            CompoundTag nbt = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)nbt, (GameProfile)this.owner);
            data.m_128365_("owner", (Tag)nbt);
        }
        return data;
    }
}

