/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import forestry.core.models.ModelBlockDefault;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public abstract class ModelBlockCached<B extends Block, K>
extends ModelBlockDefault<B, K> {
    private static final Set<ModelBlockCached<?, ?>> CACHE_PROVIDERS = new HashSet();
    private final Cache<K, BakedModel> inventoryCache;
    private final Cache<K, BakedModel> worldCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public static void clear() {
        for (ModelBlockCached<?, ?> modelBlockCached : CACHE_PROVIDERS) {
            modelBlockCached.worldCache.invalidateAll();
            modelBlockCached.inventoryCache.invalidateAll();
        }
    }

    protected ModelBlockCached(Class<B> blockClass) {
        super(blockClass);
        this.inventoryCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        CACHE_PROVIDERS.add(this);
    }

    @Override
    protected BakedModel getModel(BlockState state, ModelData extraData) {
        Object key = this.getWorldKey(state, extraData);
        BakedModel model = (BakedModel)this.worldCache.getIfPresent(key);
        if (model == null) {
            model = super.getModel(state, extraData);
            this.worldCache.put(key, (Object)model);
        }
        return model;
    }

    @Override
    protected BakedModel getModel(ItemStack stack, Level world) {
        Object key = this.getInventoryKey(stack);
        BakedModel model = (BakedModel)this.inventoryCache.getIfPresent(key);
        if (model == null) {
            model = this.bakeModel(stack, world, key);
            this.inventoryCache.put(key, (Object)model);
        }
        return model;
    }
}

