/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.inventory.IInvSlot;
import forestry.core.inventory.InvIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerInventoryManipulator
implements Iterable<IInvSlot> {
    private final IItemHandler inv;

    public ItemHandlerInventoryManipulator(IItemHandler inv) {
        this.inv = inv;
    }

    @Override
    public Iterator<IInvSlot> iterator() {
        return new InvIterator(this.inv);
    }

    @Nullable
    public ItemStack tryAddStack(ItemStack stack) {
        return this.addStack(stack, false);
    }

    @Nullable
    public ItemStack addStack(ItemStack stack) {
        return this.addStack(stack, true);
    }

    public ItemStack removeItem(Predicate<ItemStack> filter) {
        for (IInvSlot slot : this) {
            ItemStack stack = slot.getStackInSlot();
            if (stack.m_41619_() || !slot.canTakeStackFromSlot(stack) || !filter.test(stack)) continue;
            return slot.decreaseStackInSlot();
        }
        return ItemStack.f_41583_;
    }

    public boolean transferOneStack(IItemHandler dest, Predicate<ItemStack> filter) {
        return this.transferStacks(dest, filter, true);
    }

    public boolean transferStacks(IItemHandler dest, Predicate<ItemStack> filter) {
        return this.transferStacks(dest, filter, false);
    }

    private boolean transferStacks(IItemHandler dest, Predicate<ItemStack> filter, boolean singleStack) {
        ItemHandlerInventoryManipulator destManipulator = new ItemHandlerInventoryManipulator(dest);
        boolean stacksMoved = false;
        for (int slotIndex = 0; slotIndex < this.inv.getSlots(); ++slotIndex) {
            ItemStack targetStack = this.inv.extractItem(slotIndex, Integer.MAX_VALUE, true);
            if (targetStack.m_41619_() || !filter.test(targetStack)) continue;
            int extractStackSize = targetStack.m_41613_();
            ItemStack remaining = destManipulator.tryAddStack(targetStack);
            if (remaining != null) {
                extractStackSize -= remaining.m_41613_();
            }
            if (extractStackSize <= 0) continue;
            ItemStack extracted = this.inv.extractItem(slotIndex, extractStackSize, false);
            destManipulator.addStack(extracted);
            stacksMoved = true;
            if (!singleStack) continue;
            return true;
        }
        return stacksMoved;
    }

    @Nullable
    protected ItemStack addStack(ItemStack stack, boolean doAdd) {
        if (stack.m_41619_()) {
            return null;
        }
        stack = stack.m_41777_();
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>(this.inv.getSlots());
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>(this.inv.getSlots());
        for (IInvSlot slot : new ItemHandlerInventoryManipulator(this.inv)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot().m_41619_()) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(filledSlots, stack, injected, doAdd);
        injected = this.tryPut(emptySlots, stack, injected, doAdd);
        stack.m_41774_(injected);
        return stack;
    }

    private int tryPut(List<IInvSlot> slots, ItemStack stack, int injected, boolean doAdd) {
        if (injected >= stack.m_41613_()) {
            return injected;
        }
        for (IInvSlot slot : slots) {
            ItemStack stackToInsert = stack.m_41777_();
            int stackToInsertSize = stack.m_41613_() - injected;
            stackToInsert.m_41764_(stackToInsertSize);
            ItemStack remainder = this.inv.insertItem(slot.getIndex(), stackToInsert, !doAdd);
            if (remainder.m_41619_()) {
                return stack.m_41613_();
            }
            if ((injected += stackToInsertSize - remainder.m_41613_()) < stack.m_41613_()) continue;
            return injected;
        }
        return injected;
    }
}

