/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.api.genetics.IIndividual;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.TileEscritoire;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SlotUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class InventoryEscritoire
extends InventoryAdapterTile<TileEscritoire> {
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_RESULTS_1 = 1;
    public static final short SLOTS_RESULTS_COUNT = 6;
    public static final short SLOT_INPUT_1 = 7;
    public static final short SLOTS_INPUT_COUNT = 5;

    public InventoryEscritoire(TileEscritoire escritoire) {
        super(escritoire, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (slotIndex >= 7 && slotIndex < 7 + ((TileEscritoire)this.tile).getGame().getSampleSize(5)) {
            ItemStack specimen = this.m_8020_(0);
            if (specimen.m_41619_()) {
                return false;
            }
            IIndividual individual = IIndividualHandlerItem.getIndividual(specimen);
            if (individual != null) {
                return individual.getType().getResearchSuitability(individual.getSpecies().cast(), stack) > 0.0f;
            }
            return false;
        }
        return slotIndex == 0 && IIndividualHandlerItem.isIndividual(stack);
    }

    @Override
    public boolean isLocked(int slotIndex) {
        if (slotIndex == 0) {
            return false;
        }
        if (this.m_8020_(0).m_41619_()) {
            return true;
        }
        if (SlotUtil.isSlotInRange(slotIndex, 7, 5)) {
            return slotIndex >= 7 + ((TileEscritoire)this.tile).getGame().getSampleSize(5);
        }
        return false;
    }

    @Override
    public boolean m_7157_(int slotIndex, ItemStack itemstack, Direction side) {
        return SlotUtil.isSlotInRange(slotIndex, 1, 6);
    }

    @Override
    public void m_6836_(int slotIndex, ItemStack itemstack) {
        super.m_6836_(slotIndex, itemstack);
        if (slotIndex == 0) {
            Level level;
            ItemStack specimen = this.m_8020_(0);
            if (!IIndividualHandlerItem.isIndividual(specimen) && !specimen.m_41619_() && IIndividualHandlerItem.isIndividual(specimen = GeneticsUtil.convertToGeneticEquivalent(specimen))) {
                super.m_6836_(0, specimen);
            }
            if ((level = ((TileEscritoire)this.tile).m_58904_()) != null && !level.f_46443_) {
                EscritoireGame game = ((TileEscritoire)this.tile).getGame();
                game.initialize(specimen);
            }
        }
    }
}

