/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import forestry.api.client.ForestrySprites;
import forestry.api.client.IForestryClientApi;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class HintLedger
extends Ledger {
    private final Component hintString;
    private final Component hintTooltip;

    public HintLedger(LedgerManager manager, List<String> hints) {
        super(manager, "hint");
        int position = new Random().nextInt(hints.size());
        String hint = hints.get(position);
        this.hintString = Component.m_237115_((String)("for.hints." + hint + ".desc"));
        this.hintTooltip = Component.m_237115_((String)("for.hints." + hint + ".tag"));
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        int lineCount = fontRenderer.m_92923_((FormattedText)this.hintString, this.maxTextWidth).size();
        Objects.requireNonNull(fontRenderer);
        this.maxHeight = (lineCount + 1) * 9 + 20;
    }

    @Override
    public void draw(GuiGraphics graphics, int y, int x) {
        this.drawBackground(graphics, y, x);
        this.drawSprite(graphics, IForestryClientApi.INSTANCE.getTextureManager().getSprite(ForestrySprites.MISC_HINT), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(graphics, (Component)Component.m_237115_((String)"for.gui.didyouknow").m_130946_("?"), x + 22, y + 8);
        this.drawSplitText(graphics, this.hintString, x + 12, y + 20, this.maxTextWidth);
    }

    @Override
    public Component getTooltip() {
        return this.hintTooltip;
    }
}

