/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IError;
import forestry.api.core.IErrorLogicSource;
import forestry.api.modules.IForestryPacketClient;
import forestry.core.gui.ContainerForestry;
import forestry.core.network.packets.PacketErrorUpdate;
import forestry.core.network.packets.PacketGuiEnergy;
import forestry.core.network.packets.PacketGuiStream;
import forestry.core.tiles.IPowerHandler;
import forestry.core.tiles.TilePowered;
import forestry.core.tiles.TileUtil;
import forestry.energy.ForestryEnergyStorage;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ContainerTile<T extends BlockEntity>
extends ContainerForestry {
    protected final T tile;
    @Nullable
    private Set<IError> previousErrorStates;
    private int previousEnergyManagerData = 0;
    private int previousWorkCounter = 0;
    private int previousTicksPerWorkCycle = 0;

    protected ContainerTile(int windowId, MenuType<?> type, Inventory playerInventory, T tile, int xInv, int yInv) {
        super(windowId, type, playerInventory.f_35978_);
        this.addPlayerInventory(playerInventory, xInv, yInv);
        this.tile = tile;
    }

    @Deprecated(forRemoval=true)
    protected ContainerTile(int windowId, MenuType<?> type, T tile) {
        super(windowId, type, null);
        this.tile = tile;
    }

    protected ContainerTile(int windowId, MenuType<?> type, T tile, Player player) {
        super(windowId, type, player);
        this.tile = tile;
    }

    @Override
    protected final boolean canAccess(Player player) {
        return true;
    }

    public final boolean m_6875_(Player player) {
        return TileUtil.isUsableByPlayer(player, this.tile);
    }

    public void m_38946_() {
        T energyManagerData2;
        ForestryEnergyStorage energyStorage;
        int energyManagerData2;
        Record packet;
        super.m_38946_();
        T t = this.tile;
        if (t instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)t;
            Set<IError> errorStates = errorLogicSource.getErrorLogic().getErrors();
            if (!errorStates.equals(this.previousErrorStates)) {
                packet = new PacketErrorUpdate((BlockEntity)this.tile, errorLogicSource);
                this.sendPacketToListeners((IForestryPacketClient)((Object)packet));
            }
            this.previousErrorStates = Set.copyOf(errorStates);
        }
        if (this.tile instanceof IPowerHandler && (energyManagerData2 = (energyStorage = ((IPowerHandler)this.tile).getEnergyManager()).getEnergyStored()) != this.previousEnergyManagerData) {
            packet = new PacketGuiEnergy(this.f_38840_, energyManagerData2);
            this.sendPacketToListeners((IForestryPacketClient)((Object)packet));
            this.previousEnergyManagerData = energyManagerData2;
        }
        if ((energyManagerData2 = this.tile) instanceof TilePowered) {
            int ticksPerWorkCycle;
            TilePowered tilePowered = (TilePowered)energyManagerData2;
            boolean guiNeedsUpdate = false;
            int workCounter = tilePowered.getWorkCounter();
            if (workCounter != this.previousWorkCounter) {
                guiNeedsUpdate = true;
                this.previousWorkCounter = workCounter;
            }
            if ((ticksPerWorkCycle = tilePowered.getTicksPerWorkCycle()) != this.previousTicksPerWorkCycle) {
                guiNeedsUpdate = true;
                this.previousTicksPerWorkCycle = ticksPerWorkCycle;
            }
            if (guiNeedsUpdate) {
                PacketGuiStream packet2 = new PacketGuiStream(tilePowered);
                this.sendPacketToListeners(packet2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onGuiEnergy(int energyStored) {
        T t = this.tile;
        if (t instanceof IPowerHandler) {
            IPowerHandler handler = (IPowerHandler)t;
            ForestryEnergyStorage energyStorage = handler.getEnergyManager();
            energyStorage.setEnergyStored(energyStored);
        }
    }

    public T getTile() {
        return this.tile;
    }
}

