/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.collect.ImmutableList;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.util.RandomSource;

public class MutationManager<S extends ISpecies<?>>
implements IMutationManager<S> {
    private final IdentityHashMap<S, List<IMutation<S>>> mutationsFrom = new IdentityHashMap();
    private final IdentityHashMap<S, List<IMutation<S>>> mutationsInto = new IdentityHashMap();
    private final ImmutableList<IMutation<S>> mutations;

    public MutationManager(ImmutableList<IMutation<S>> mutations) {
        this.mutations = mutations;
        for (IMutation mutation : mutations) {
            this.mutationsFrom.computeIfAbsent(mutation.getFirstParent(), k -> new ArrayList()).add(mutation);
            this.mutationsFrom.computeIfAbsent(mutation.getSecondParent(), k -> new ArrayList()).add(mutation);
            this.mutationsInto.computeIfAbsent(mutation.getResult(), k -> new ArrayList()).add(mutation);
        }
    }

    @Override
    public List<IMutation<S>> getMutationsFrom(S species) {
        return this.mutationsFrom.getOrDefault(species, List.of());
    }

    @Override
    public List<IMutation<S>> getMutationsInto(S species) {
        return this.mutationsInto.getOrDefault(species, List.of());
    }

    @Override
    public ObjectArrayList<IMutation<S>> getCombinations(S firstParent, S secondParent) {
        ObjectArrayList mutations = new ObjectArrayList();
        if (firstParent == secondParent) {
            return mutations;
        }
        List<IMutation<S>> firstMutations = this.mutationsFrom.get(firstParent);
        if (firstMutations == null) {
            return mutations;
        }
        for (IMutation<S> mutation : firstMutations) {
            if (!mutation.isPartner((ISpecies<?>)secondParent)) continue;
            mutations.add(mutation);
        }
        return mutations;
    }

    @Override
    public List<IMutation<S>> getAllMutations() {
        return this.mutations;
    }

    @Override
    public List<? extends IMutation<S>> getCombinationsShuffled(S firstParent, S secondParent, RandomSource rand) {
        ObjectArrayList<IMutation<S>> mutations = this.getCombinations(firstParent, secondParent);
        Util.m_214673_(mutations, (RandomSource)rand);
        return mutations;
    }
}

