/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.Forestry;
import forestry.api.ForestryCapabilities;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.config.ForestryConfig;
import forestry.core.genetics.capability.SerializableIndividualHandlerItem;
import forestry.core.items.ItemForestry;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class ItemGE
extends ItemForestry {
    protected final ILifeStage stage;

    protected ItemGE(Item.Properties properties, ILifeStage stage) {
        super(properties.setNoRepair());
        this.stage = stage;
    }

    protected abstract ISpecies<?> getSpecies(ItemStack var1);

    protected abstract ISpeciesType<?, ?> getType();

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        Tag parent = nbt != null && nbt.m_128441_("Parent") ? nbt.m_128423_("Parent") : (stack.m_41783_() != null && stack.m_41737_("ForgeCaps") != null && stack.m_41737_("ForgeCaps").m_128441_("Parent") ? stack.m_41737_("ForgeCaps").m_128423_("Parent") : null);
        if (parent == null) {
            return new SerializableIndividualHandlerItem(this.getType(), stack, (IIndividual)this.getType().getDefaultSpecies().createIndividual(), this.stage);
        }
        return new SerializableIndividualHandlerItem(this.getType(), stack, (IIndividual)SpeciesUtil.deserializeIndividual(this.getType(), parent), this.stage);
    }

    public Component m_7626_(ItemStack stack) {
        return stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM).map(handler -> GeneticsUtil.getItemName(handler.getStage(), handler.getIndividual().getSpecies())).orElseGet(() -> super.m_7626_(stack));
    }

    public boolean m_5812_(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        ISpecies<?> species = this.getSpecies(stack);
        return species.hasGlint() && (Boolean)ForestryConfig.CLIENT.enableGlints.get() != false;
    }

    public static void appendGeneticsTooltip(ItemStack stack, List<Component> tooltip) {
        if (!stack.m_41782_()) {
            return;
        }
        MutableBoolean analyzed = new MutableBoolean();
        IIndividualHandlerItem.ifPresent(stack, individual -> {
            if (individual.isAnalyzed()) {
                if (Screen.m_96638_()) {
                    individual.getSpecies().addTooltip(individual, tooltip);
                } else {
                    tooltip.add((Component)Component.m_237110_((String)"for.gui.tooltip.tmi", (Object[])new Object[]{"< %s >"}).m_130938_(style -> style.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
                }
                analyzed.setTrue();
            }
        });
        if (analyzed.isFalse()) {
            tooltip.add((Component)Component.m_237110_((String)"for.gui.unknown", (Object[])new Object[]{"< %s >"}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        ItemGE.appendGeneticsTooltip(stack, tooltip);
    }

    public String getCreatorModId(ItemStack stack) {
        ISpecies<?> species = this.getSpecies(stack);
        return species.id().m_135827_();
    }

    public static <S extends ISpecies<I>, I extends IIndividual> void addCreativeItems(ILifeStage stage, List<ItemStack> subItems, boolean hideSecrets, ISpeciesType<S, I> type) {
        for (ISpecies species : type.getAllSpecies()) {
            if (hideSecrets && species.isSecret() && !Forestry.DEBUG) continue;
            subItems.add(species.createStack(species.createIndividual(), stage));
        }
    }
}

