/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.core.utils.SpeciesUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class Individual<S extends ISpecies<I>, I extends IIndividual, T extends ISpeciesType<S, I>>
implements IIndividual {
    protected final S species;
    protected final S inactiveSpecies;
    protected final IGenome genome;
    @Nullable
    protected IGenome mate;
    protected boolean analyzed;

    protected Individual(IGenome genome) {
        this.species = genome.getActiveSpecies();
        this.inactiveSpecies = genome.getInactiveSpecies();
        this.genome = genome;
    }

    protected Individual(IGenome genome, Optional<IGenome> mate, boolean analyzed) {
        this(genome);
        this.mate = mate.orElse(null);
        this.analyzed = analyzed;
    }

    protected static <I extends IIndividual> Products.P3<RecordCodecBuilder.Mu<I>, IGenome, Optional<IGenome>, Boolean> fields(RecordCodecBuilder.Instance<I> instance, Codec<IGenome> genomeCodec) {
        return instance.group((App)genomeCodec.fieldOf("genome").forGetter(IIndividual::getGenome), (App)genomeCodec.optionalFieldOf("mate").forGetter(IIndividual::getMateOptional), (App)Codec.BOOL.fieldOf("analyzed").forGetter(IIndividual::isAnalyzed));
    }

    @Override
    public void setMate(@Nullable IGenome mate) {
        if (mate == null || this.genome.getKaryotype() == mate.getKaryotype()) {
            this.mate = mate;
        }
    }

    @Override
    @Nullable
    public IGenome getMate() {
        return this.mate;
    }

    @Override
    public Optional<IGenome> getMateOptional() {
        return Optional.ofNullable(this.mate);
    }

    @Override
    public IGenome getGenome() {
        return this.genome;
    }

    public T getType() {
        return (T)this.species.getType();
    }

    public S getSpecies() {
        return this.species;
    }

    public S getInactiveSpecies() {
        return this.inactiveSpecies;
    }

    @Override
    public boolean isAnalyzed() {
        return this.analyzed;
    }

    @Override
    public boolean analyze() {
        if (this.analyzed) {
            return false;
        }
        this.analyzed = true;
        return true;
    }

    public I copy() {
        return this.copyWithGenome(this.genome);
    }

    public I copyWithGenome(IGenome newGenome) {
        Object individual = this.species.createIndividual(newGenome);
        this.copyPropertiesTo(individual);
        return individual;
    }

    @OverridingMethodsMustInvokeSuper
    protected void copyPropertiesTo(I other) {
    }

    @Override
    public void saveToStack(ItemStack stack) {
        Tag individual = SpeciesUtil.serializeIndividual(this);
        if (individual != null) {
            CompoundTag forgeCaps = new CompoundTag();
            forgeCaps.m_128365_("Parent", individual);
            stack.m_41784_().m_128365_("ForgeCaps", (Tag)forgeCaps);
        }
    }

    @Override
    public ItemStack createStack(ILifeStage stage) {
        ItemStack stack = new ItemStack((ItemLike)stage.getItemForm());
        this.saveToStack(stack);
        return stack;
    }
}

