/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.ForestryFluids;
import forestry.core.fluids.ITankManager;
import forestry.core.fluids.ITankUpdateHandler;
import forestry.core.fluids.StandardTank;
import forestry.core.network.IStreamable;
import forestry.core.network.packets.PacketTankLevelUpdate;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.IRenderableTile;
import forestry.core.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankManager
implements ITankManager,
ITankUpdateHandler,
IStreamable,
INbtWritable,
INbtReadable {
    private final List<StandardTank> tanks = new ArrayList<StandardTank>();
    private final Table<AbstractContainerMenu, Integer, FluidStack> prevFluidStacks = HashBasedTable.create();
    @Nullable
    private final ILiquidTankTile tile;

    public TankManager() {
        this.tile = null;
    }

    public TankManager(ILiquidTankTile tile, StandardTank ... tanks) {
        this.tile = tile;
        for (StandardTank tank : tanks) {
            this.add(tank);
        }
    }

    public void add(StandardTank tank) {
        this.tanks.add(tank);
        int index = this.tanks.indexOf(tank);
        tank.setTankUpdateHandler(this);
        tank.setTankIndex(index);
    }

    @Override
    public CompoundTag write(CompoundTag data) {
        ListTag tagList = new ListTag();
        for (byte slot = 0; slot < this.tanks.size(); slot = (byte)((byte)(slot + 1))) {
            StandardTank tank = this.tanks.get(slot);
            if (tank.getFluid().isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("tank", slot);
            tank.writeToNBT(tag);
            tagList.add((Object)tag);
        }
        data.m_128365_("tanks", (Tag)tagList);
        return data;
    }

    @Override
    public void read(CompoundTag data) {
        for (Tag tag : data.m_128437_("tanks", 10)) {
            CompoundTag compound = (CompoundTag)tag;
            byte slot = compound.m_128445_("tank");
            if (slot < 0 || slot >= this.tanks.size()) continue;
            StandardTank tank = this.tanks.get(slot);
            tank.readFromNBT(compound);
            this.updateTankLevels(tank);
        }
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        for (StandardTank tank : this.tanks) {
            tank.writeData(data);
        }
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        for (StandardTank tank : this.tanks) {
            tank.readData(data);
        }
    }

    @Override
    public void sendAllTanks(AbstractContainerMenu container, ServerPlayer player) {
        for (StandardTank tank : this.tanks) {
            this.sendTankUpdate(container, player, tank);
        }
    }

    @Override
    public void onClosed(AbstractContainerMenu container) {
        for (StandardTank tank : this.tanks) {
            this.prevFluidStacks.remove((Object)container, (Object)tank.getTankIndex());
        }
    }

    @Override
    public void broadcastChanges(AbstractContainerMenu container, ServerPlayer players) {
        for (StandardTank tank : this.tanks) {
            this.sendTankUpdate(container, players, tank.getTankIndex());
        }
    }

    private void sendTankUpdate(AbstractContainerMenu container, ServerPlayer player, int tankIndex) {
        StandardTank tank = this.tanks.get(tankIndex);
        if (tank == null) {
            return;
        }
        FluidStack fluidStack = tank.getFluid();
        FluidStack prev = (FluidStack)this.prevFluidStacks.get((Object)container, (Object)tankIndex);
        if (prev == null) {
            prev = FluidStack.EMPTY;
        }
        if (FluidHelper.areFluidStacksEqual(fluidStack, prev)) {
            return;
        }
        this.sendTankUpdate(container, player, tank);
    }

    private void sendTankUpdate(AbstractContainerMenu container, ServerPlayer player, StandardTank tank) {
        if (this.tile != null) {
            int tankIndex = tank.getTankIndex();
            FluidStack fluid = tank.getFluid();
            NetworkUtil.sendToPlayer(new PacketTankLevelUpdate(this.tile, tankIndex, fluid), player);
            if (fluid.isEmpty()) {
                this.prevFluidStacks.remove((Object)container, (Object)tankIndex);
            } else {
                this.prevFluidStacks.put((Object)container, (Object)tankIndex, (Object)fluid.copy());
            }
        }
    }

    @Override
    public void processTankUpdate(int tankIndex, @Nullable FluidStack contents) {
        if (tankIndex < 0 || tankIndex > this.tanks.size()) {
            return;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        tank.setFluid(contents);
    }

    @Override
    @Nullable
    public IFluidTank getTank(int tankIndex) {
        return (IFluidTank)this.tanks.get(tankIndex);
    }

    public int getTanks() {
        return this.tanks.size();
    }

    public FluidStack getFluidInTank(int tankIndex) {
        IFluidTank tank = this.getTank(tankIndex);
        if (tank == null) {
            return FluidStack.EMPTY;
        }
        return tank.getFluid();
    }

    public int getTankCapacity(int tankIndex) {
        IFluidTank tank = this.getTank(tankIndex);
        if (tank == null) {
            return 0;
        }
        return tank.getCapacity();
    }

    public boolean isFluidValid(int tankIndex, @Nonnull FluidStack stack) {
        IFluidTank tank = this.getTank(tankIndex);
        if (tank == null) {
            return false;
        }
        return tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankAcceptsFluid(tank, resource)) continue;
            return this.fill(tank.getTankIndex(), resource, action);
        }
        return 0;
    }

    public int fill(int tankIndex, FluidStack resource, IFluidHandler.FluidAction action) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return 0;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (!tank.canFill()) {
            return 0;
        }
        return tank.fill(resource, action);
    }

    @Override
    public void updateTankLevels(StandardTank tank) {
        if (!(this.tile instanceof IRenderableTile)) {
            return;
        }
        Level world = this.tile.getWorldObj();
        if (world == null || world.f_46443_) {
            return;
        }
        int tankIndex = tank.getTankIndex();
        PacketTankLevelUpdate tankLevelUpdate = new PacketTankLevelUpdate(this.tile, tankIndex, tank.getFluid());
        NetworkUtil.sendNetworkPacket(tankLevelUpdate, this.tile.getCoordinates(), world);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrain(tank)) continue;
            return this.drain(tank.getTankIndex(), maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int tankIndex, int maxDrain, IFluidHandler.FluidAction action) {
        if (tankIndex < 0 || tankIndex >= this.tanks.size()) {
            return FluidStack.EMPTY;
        }
        StandardTank tank = this.tanks.get(tankIndex);
        if (!tank.canDrain()) {
            return FluidStack.EMPTY;
        }
        return tank.drain(maxDrain, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        for (StandardTank tank : this.tanks) {
            if (!TankManager.tankCanDrainFluid(tank, resource)) continue;
            return this.drain(tank.getTankIndex(), resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    @Nullable
    public FluidStack getFluid(int tankIndex) {
        return this.tanks.get(tankIndex).getFluid();
    }

    @Override
    public boolean canFillFluidType(FluidStack fluidStack) {
        for (StandardTank tank : this.tanks) {
            if (!tank.isFluidValid(fluidStack)) continue;
            return true;
        }
        return false;
    }

    private static boolean tankAcceptsFluid(StandardTank tank, FluidStack fluidStack) {
        return tank.canFill() && tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    private static boolean tankCanDrain(StandardTank tank) {
        if (!tank.canDrain()) {
            return false;
        }
        FluidStack drained = tank.drain(1, IFluidHandler.FluidAction.SIMULATE);
        return !drained.isEmpty() && drained.getAmount() > 0;
    }

    private static boolean tankCanDrainFluid(StandardTank tank, FluidStack fluidStack) {
        return ForestryFluids.areEqual(tank.getFluidType(), fluidStack) && TankManager.tankCanDrain(tank);
    }
}

