/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;

public class StillRecipeBuilder {
    private int timePerUnit;
    private FluidStack input;
    private FluidStack output;

    public StillRecipeBuilder setTimePerUnit(int timePerUnit) {
        this.timePerUnit = timePerUnit;
        return this;
    }

    public StillRecipeBuilder setInput(FluidStack input) {
        this.input = input;
        return this;
    }

    public StillRecipeBuilder setOutput(FluidStack output) {
        this.output = output;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.timePerUnit, this.input, this.output));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final int timePerUnit;
        private final FluidStack input;
        private final FluidStack output;

        public Result(ResourceLocation id, int timePerUnit, FluidStack input, FluidStack output) {
            this.id = id;
            this.timePerUnit = timePerUnit;
            this.input = input;
            this.output = output;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("time", (Number)this.timePerUnit);
            json.add("input", (JsonElement)RecipeSerializers.serializeFluid(this.input));
            json.add("output", (JsonElement)RecipeSerializers.serializeFluid(this.output));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FactoryRecipeTypes.STILL.serializer();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

